/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.host;

import com.ibm.arcs.host.Host;
import com.ibm.arcs.host.HostCatalog;
import com.ibm.arcs.host.ISAType;
import com.ibm.arcs.host.KernelType;
import com.ibm.arcs.host.OperatingEnvironment;
import com.ibm.arcs.host.PlatformBits;
import com.ibm.arcs.host.UnknownOperatingEnvironmentException;
import java.io.File;

public class MultiplatformRepository {
    private File baseDirectory;

    public MultiplatformRepository(File file) {
        this.baseDirectory = file;
    }

    public File getPlatformDirectory(Host host) throws UnknownOperatingEnvironmentException {
        File file = new File(String.valueOf(this.baseDirectory.getAbsolutePath()) + File.separator + this.getPlatformPath(host));
        return file;
    }

    private String getPlatformPath(Host host) throws UnknownOperatingEnvironmentException {
        OperatingEnvironment operatingEnvironment = host.getOperatingEnvironment();
        KernelType kernelType = operatingEnvironment.getKernel().getKernelType();
        PlatformBits platformBits = operatingEnvironment.getKernel().getKernelBits();
        ISAType iSAType = operatingEnvironment.getProcessors().get(0).getISA().getISAType();
        String string = null;
        String string2 = null;
        String string3 = null;
        switch (kernelType) {
            case AIX: {
                string = "AIX";
                string2 = platformBits.toString();
                string3 = "powerpc";
                break;
            }
            case Darwin: {
                string = "Darwin";
                string2 = platformBits.toString();
                switch (iSAType) {
                    case PowerPC: {
                        string3 = "ppc";
                        break;
                    }
                    case x86: {
                        string3 = "i386";
                    }
                }
                break;
            }
            case HPUX: {
                string = "HP-UX";
                string2 = platformBits.toString();
                switch (iSAType) {
                    case Itanium: {
                        string3 = "ia64";
                        break;
                    }
                    case PA_RISC: {
                        string3 = "pa";
                    }
                }
                break;
            }
            case IRIX: 
            case IRIX64: {
                break;
            }
            case Linux: {
                string = "Linux";
                string2 = platformBits.toString();
                block18 : switch (platformBits) {
                    case ThirtyTwo: {
                        switch (iSAType) {
                            case PowerPC: {
                                string3 = "ppc";
                                break block18;
                            }
                            case x86: {
                                string3 = "i686";
                                break block18;
                            }
                        }
                        string3 = null;
                        break;
                    }
                    case SixtyFour: {
                        switch (iSAType) {
                            case PowerPC: {
                                string3 = "ppc64";
                                break block18;
                            }
                            case x86: {
                                string3 = "x86_64";
                                break block18;
                            }
                        }
                        string3 = null;
                    }
                }
                break;
            }
            case OSF1: {
                break;
            }
            case SunOS: {
                break;
            }
            case Windows: {
                string = "Windows";
                string2 = platformBits.toString();
            }
        }
        if (string != null && string2 != null && string3 != null) {
            return String.valueOf(string) + File.separator + string2 + File.separator + string3;
        }
        throw new UnknownOperatingEnvironmentException(operatingEnvironment, "Unknown platform detected. Ask developer for assistance with this platform.");
    }

    public void extractFromArchive(File file, String string, File file2) {
    }

    public static void main(String[] stringArray) throws Exception {
        Host host = HostCatalog.getLocalHost();
        File file = new File("/informix_repo");
        MultiplatformRepository multiplatformRepository = new MultiplatformRepository(file);
        System.out.println("platformPath = " + multiplatformRepository.getPlatformPath(host));
    }
}

