/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.host;

import com.ibm.arcs.host.Host;
import com.ibm.arcs.host.Kernel;
import com.ibm.arcs.host.Processor;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public final class OperatingEnvironment
implements Serializable {
    private Host host;
    private Vector<Processor> processors;
    private Kernel kernel;

    public OperatingEnvironment(Host host, Processor processor, Kernel kernel) {
        this.host = host;
        this.processors = new Vector();
        this.processors.add(processor);
        this.kernel = kernel;
    }

    public OperatingEnvironment(Host host, Collection<Processor> collection, Kernel kernel) {
        this.host = host;
        this.processors = new Vector<Processor>(collection);
        this.kernel = kernel;
    }

    OperatingEnvironment(Host host) {
        this.host = host;
        this.processors = new Vector();
        this.kernel = null;
        this.configure();
    }

    public Host getHost() {
        return this.host;
    }

    public List<Processor> getProcessors() {
        return Collections.unmodifiableList(this.processors);
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public final void configure() {
        if (this.host.isLocalHost()) {
            OperatingEnvironment.configureLocalHostOperatingEnvironment(this);
        } else {
            OperatingEnvironment.configureRemoteHostOperatingEnvironment(this);
        }
    }

    private static void configureRemoteHostOperatingEnvironment(OperatingEnvironment operatingEnvironment) {
    }

    private static void configureLocalHostOperatingEnvironment(OperatingEnvironment operatingEnvironment) {
        operatingEnvironment.processors = Processor.getProcessors(operatingEnvironment);
        operatingEnvironment.kernel = Kernel.getKernel(operatingEnvironment);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.kernel == null ? 0 : this.kernel.hashCode());
        n = 31 * n + (this.processors == null ? 0 : this.processors.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof OperatingEnvironment)) {
            return false;
        }
        OperatingEnvironment operatingEnvironment = (OperatingEnvironment)object;
        if (this.kernel == null ? operatingEnvironment.kernel != null : !this.kernel.equals(operatingEnvironment.kernel)) {
            return false;
        }
        return !(this.processors == null ? operatingEnvironment.processors != null : !this.processors.equals(operatingEnvironment.processors));
    }
}

