/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.host;

import com.ibm.arcs.host.ISA;
import com.ibm.arcs.host.OperatingEnvironment;
import com.ibm.arcs.host.PlatformBits;
import com.ibm.arcs.host.ProcessorValidator;
import java.io.Serializable;
import java.util.Vector;

public class Processor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ISA isa;
    private PlatformBits addressBitSize;
    private PlatformBits longBitSize;

    public Processor(ISA iSA, PlatformBits platformBits, PlatformBits platformBits2) {
        this.isa = iSA;
        this.addressBitSize = platformBits;
        this.longBitSize = platformBits2;
        if (!ProcessorValidator.isValidCPU(this)) {
            throw new AssertionError((Object)"Invalid processor specified");
        }
    }

    public static Vector<Processor> getProcessors(OperatingEnvironment operatingEnvironment) {
        if (operatingEnvironment.getHost().isLocalHost()) {
            return Processor.getLocalHostProcessors(operatingEnvironment);
        }
        return Processor.getRemoteHostProcessors(operatingEnvironment);
    }

    public ISA getISA() {
        return this.isa;
    }

    public PlatformBits getAddressBitSize() {
        return this.addressBitSize;
    }

    public PlatformBits getLongBitSize() {
        return this.longBitSize;
    }

    private static Vector<Processor> getRemoteHostProcessors(OperatingEnvironment operatingEnvironment) {
        Vector<Processor> vector = new Vector<Processor>();
        return vector;
    }

    private static Vector<Processor> getLocalHostProcessors(OperatingEnvironment operatingEnvironment) {
        Vector<Processor> vector = new Vector<Processor>();
        Processor processor = new Processor(ISA.getLocalHostISA(), Processor.getLocalHostAddressBitSize(), Processor.getLocalHostLongBitSize());
        vector.add(processor);
        return vector;
    }

    private static PlatformBits getLocalHostAddressBitSize() {
        String string = System.getProperty("sun.arch.data.model");
        if (string.equals("32")) {
            return PlatformBits.ThirtyTwo;
        }
        if (string.equals("64")) {
            return PlatformBits.SixtyFour;
        }
        throw new RuntimeException("Unsupported local host address bit size");
    }

    private static PlatformBits getLocalHostLongBitSize() {
        String string = System.getProperty("sun.arch.data.model");
        if (string.equals("32")) {
            return PlatformBits.ThirtyTwo;
        }
        if (string.equals("64")) {
            return PlatformBits.SixtyFour;
        }
        throw new RuntimeException("Unsupported local host long bit size");
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.addressBitSize == null ? 0 : this.addressBitSize.hashCode());
        n = 31 * n + (this.isa == null ? 0 : this.isa.hashCode());
        n = 31 * n + (this.longBitSize == null ? 0 : this.longBitSize.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Processor)) {
            return false;
        }
        Processor processor = (Processor)object;
        if (this.addressBitSize != processor.addressBitSize) {
            return false;
        }
        if (this.isa == null ? processor.isa != null : !this.isa.equals(processor.isa)) {
            return false;
        }
        return this.longBitSize == processor.longBitSize;
    }
}

