/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.nativelibrary;

import com.ibm.arcs.host.MultiplatformRepository;
import java.io.File;

public class NativeLibrary {
    private String name;
    private File file;
    private boolean loaded;
    private static Runtime runtime = Runtime.getRuntime();

    NativeLibrary(File file) {
        this.file = file;
        this.name = NativeLibrary.extractLibraryNameFromFile(this.file);
        this.loaded = false;
    }

    NativeLibrary(String string, MultiplatformRepository multiplatformRepository) {
        this.name = string;
        this.loaded = false;
    }

    private static String extractLibraryNameFromFile(File file) {
        String string = file.getAbsolutePath();
        int n = 1 + string.lastIndexOf(File.separator);
        int n2 = string.lastIndexOf(".");
        String string2 = string.substring(n, n2);
        return string2;
    }

    public String getName() {
        return this.name;
    }

    public String getFilePath() {
        return this.file.getAbsolutePath();
    }

    void load() {
        try {
            runtime.load(this.getFilePath());
            this.loaded = true;
        }
        catch (Exception exception) {
            this.loaded = false;
        }
    }

    boolean isLoaded() {
        return this.loaded;
    }
}

