/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.nativelibrary;

import com.ibm.arcs.host.Host;
import com.ibm.arcs.host.HostCatalog;
import com.ibm.arcs.host.KernelType;
import com.ibm.arcs.host.MultiplatformRepository;
import com.ibm.arcs.host.UnknownOperatingEnvironmentException;
import com.ibm.arcs.nativelibrary.NativeLibrary;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class NativeLibraryManager {
    private static ReentrantLock lock = new ReentrantLock();
    private static ArrayList<NativeLibrary> loadedLibraries = new ArrayList();
    private static ArrayList<MultiplatformRepository> libraryRepositories = new ArrayList();
    private static final Host LOCALHOST = HostCatalog.getLocalHost();
    public static final String NATIVE_LIBRARY_DIRECTORY_NAME = "lib";

    private NativeLibraryManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLibraryRepository(MultiplatformRepository multiplatformRepository) {
        ReentrantLock reentrantLock = lock;
        synchronized (reentrantLock) {
            libraryRepositories.add(multiplatformRepository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(NativeLibrary nativeLibrary) {
        ReentrantLock reentrantLock = lock;
        synchronized (reentrantLock) {
            nativeLibrary.load();
            if (nativeLibrary.isLoaded()) {
                loadedLibraries.add(nativeLibrary);
            }
        }
    }

    public static void load(String string) {
        NativeLibrary nativeLibrary = new NativeLibrary(new File(string));
        NativeLibraryManager.load(nativeLibrary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibrary(String string) throws UnknownOperatingEnvironmentException {
        ReentrantLock reentrantLock = lock;
        synchronized (reentrantLock) {
            int n = 0;
            while (n < libraryRepositories.size()) {
                File file;
                File file2 = libraryRepositories.get(n).getPlatformDirectory(LOCALHOST);
                if (file2.exists() && (file = new File(String.valueOf(file2.getAbsolutePath()) + File.separator + NATIVE_LIBRARY_DIRECTORY_NAME)).exists()) {
                    String string2 = NativeLibraryManager.getNativeLibraryFileExtension(LOCALHOST);
                    File file3 = new File(file.getAbsoluteFile() + File.separator + string + string2);
                    NativeLibrary nativeLibrary = new NativeLibrary(file3);
                    NativeLibraryManager.load(nativeLibrary);
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeLibrary[] getLoaded() {
        ReentrantLock reentrantLock = lock;
        synchronized (reentrantLock) {
            NativeLibrary[] nativeLibraryArray = loadedLibraries.toArray(new NativeLibrary[loadedLibraries.size()]);
            return nativeLibraryArray;
        }
    }

    private static String getNativeLibraryFileExtension(Host host) {
        KernelType kernelType = host.getOperatingEnvironment().getKernel().getKernelType();
        switch (kernelType) {
            case AIX: 
            case HPUX: 
            case IRIX: 
            case IRIX64: 
            case Linux: 
            case OSF1: 
            case SunOS: 
            case UNKNOWN: {
                return ".so";
            }
            case Windows: {
                return ".dll";
            }
            case Darwin: {
                return ".dylib";
            }
        }
        Throwable throwable = new Throwable("Unsupported operating system/kernel");
        throw new RuntimeException("Cannot determine native library file extension", throwable);
    }

    public static void main(String[] stringArray) throws UnknownOperatingEnvironmentException {
        MultiplatformRepository multiplatformRepository = new MultiplatformRepository(new File("/tmp/nativeLibraryRepository"));
        NativeLibraryManager.addLibraryRepository(multiplatformRepository);
        String string = "libGL";
        NativeLibraryManager.loadLibrary(string);
        System.out.println("loaded libraries");
        NativeLibrary[] nativeLibraryArray = NativeLibraryManager.getLoaded();
        int n = nativeLibraryArray.length;
        int n2 = 0;
        while (n2 < n) {
            NativeLibrary nativeLibrary = nativeLibraryArray[n2];
            System.out.println("  " + nativeLibrary.getName());
            ++n2;
        }
    }
}

