/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.host.ui.widgets;

import com.ibm.arcs.basic.strings.StringUtils;
import com.ibm.arcs.host.Host;
import com.ibm.arcs.host.ui.Messages;
import com.ibm.arcs.status.ui.AbstractStatusPublishingComposite;
import com.ibm.arcs.status.ui.widgets.IValidatedTextField;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class HostNameText
extends AbstractStatusPublishingComposite
implements IValidatedTextField {
    private final Text hostText;
    private final int priority;

    public HostNameText(Composite composite, int n, int n2) {
        super(composite, 0);
        this.priority = n2;
        this.setLayout((Layout)new FillLayout());
        this.hostText = new Text((Composite)this, n);
        this.hostText.setToolTipText(Messages.ToolTip_EnterHostName);
        this.hostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                HostNameText.this.verifyAndPublishStatus();
            }
        });
    }

    public IStatus getStatus() {
        Status status = this.getText().length() == 0 ? new Status(4, "com.ibm.arcs.host.ui", this.priority, Messages.Error_HostNameIsRequired, null) : (StringUtils.containsSpaces((String)this.getText()) ? new Status(4, "com.ibm.arcs.host.ui", this.priority, Messages.Error_HostNameCannotContainSpaces, null) : new Status(0, "com.ibm.arcs.host.ui", this.priority, "", null));
        return status;
    }

    public String getText() {
        return this.hostText.getText();
    }

    public void setToolTipText(String string) {
        this.hostText.setToolTipText(string);
    }

    public boolean isValid() {
        return !StringUtils.containsSpaces((String)this.getText());
    }

    public boolean isLocalHost() {
        return Host.isLocalHost((String)this.getText().trim());
    }
}

