/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.host.ui.widgets;

import com.ibm.arcs.basic.strings.StringUtils;
import com.ibm.arcs.host.ui.Messages;
import com.ibm.arcs.status.ui.AbstractStatusPublishingComposite;
import com.ibm.arcs.status.ui.widgets.IValidatedTextField;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class HostPortText
extends AbstractStatusPublishingComposite
implements IValidatedTextField {
    private final Text portText;
    private final int priority;

    public HostPortText(Composite composite, int n, int n2) {
        super(composite, 0);
        this.priority = n2;
        this.setLayout((Layout)new FillLayout());
        this.portText = new Text((Composite)this, n);
        this.portText.setToolTipText(Messages.ToolTip_EnterPortNumber);
        this.portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                HostPortText.this.verifyAndPublishStatus();
            }
        });
    }

    public boolean isValid() {
        try {
            Integer.parseInt(this.getText());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public String getText() {
        return this.portText.getText();
    }

    public IStatus getStatus() {
        Status status = this.getText().length() == 0 ? new Status(4, "com.ibm.arcs.host.ui", this.priority, Messages.Error_PortNumberIsRequired, null) : (StringUtils.containsSpaces((String)this.getText()) ? new Status(4, "com.ibm.arcs.host.ui", this.priority, Messages.Error_PortNumberCannotContainSpaces, null) : (!this.isValid() ? new Status(4, "com.ibm.arcs.host.ui", this.priority, Messages.Error_PortNumberMustOnlyContainDigits, null) : new Status(0, "com.ibm.arcs.host.ui", this.priority, "", null)));
        return status;
    }
}

