/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.serialization.xml;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameterXmlConverter;
import com.ibm.arcs.basic.strings.StringInputStreamUtils;
import com.ibm.arcs.serialization.xml.XmlSerializer;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerCatalog;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class XmlSerializers {
    public static final HierarchicalParameter toHierarchicalParameter(Object object, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        XmlSerializer xmlSerializer = xmlSerializerCatalog.getSerializerForClass(object.getClass());
        if (xmlSerializer == null) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.serialization.xml", "no serializer found for class: " + object.getClass().getName()));
        }
        return xmlSerializer.toHierarchicalParameter(object, xmlSerializerCatalog);
    }

    public static final String toString(Object object, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        XmlSerializer xmlSerializer = xmlSerializerCatalog.getSerializerForClass(object.getClass());
        if (xmlSerializer == null) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.serialization.xml", "no serializer found for class: " + object.getClass().getName()));
        }
        return xmlSerializer.toString(object, xmlSerializerCatalog);
    }

    public static final InputStream toInputStream(Object object, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        XmlSerializer xmlSerializer = xmlSerializerCatalog.getSerializerForClass(object.getClass());
        if (xmlSerializer == null) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.serialization.xml", "no serializer found for class: " + object.getClass().getName()));
        }
        return xmlSerializer.toInputStream(object, xmlSerializerCatalog);
    }

    public static final void writeToFile(Object object, XmlSerializerCatalog xmlSerializerCatalog, File file) throws CoreException {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fileWriter = new FileWriter(file);
            String string = XmlSerializers.toString(object, xmlSerializerCatalog);
            fileWriter.write(string);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.serialization.xml", "IOException while writing object to file", (Throwable)iOException));
        }
    }

    public static final Object fromXml(File file, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        try {
            String string = XmlSerializers.readFile(file);
            return XmlSerializers.fromXml(string, xmlSerializerCatalog);
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.serialization.xml", "IOException while reading object from file", (Throwable)iOException));
        }
    }

    public static final String readFile(File file) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[8];
        FileReader fileReader = new FileReader(file);
        while ((n = fileReader.read(cArray)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        fileReader.close();
        return stringBuffer.toString();
    }

    public static final Object fromXml(String string, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        HierarchicalParameter hierarchicalParameter = HierarchicalParameterXmlConverter.getSharedInstance().read(string);
        return XmlSerializers.fromXml(hierarchicalParameter, xmlSerializerCatalog);
    }

    public static final Object fromXml(HierarchicalParameter hierarchicalParameter, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        String string = XmlSerializers.extractTag(hierarchicalParameter);
        XmlSerializer xmlSerializer = xmlSerializerCatalog.getSerializerForTag(string);
        if (xmlSerializer == null) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.serialization.xml", "unable to find serializer for tag: " + string));
        }
        return xmlSerializer.fromXml(hierarchicalParameter, xmlSerializerCatalog);
    }

    public static final Object fromXml(InputStream inputStream, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        try {
            String string = StringInputStreamUtils.toString((InputStream)inputStream);
            return XmlSerializers.fromXml(string, xmlSerializerCatalog);
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.serialization.xml", "IOException while re-constituting object from input stream", (Throwable)iOException));
        }
    }

    private static final String extractTag(HierarchicalParameter hierarchicalParameter) {
        return hierarchicalParameter.getKey();
    }
}

