/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.serialization.xml.catalog;

import com.ibm.arcs.serialization.xml.XmlSerializer;
import com.ibm.arcs.serialization.xml.catalog.AbstractXmlSerializerCatalog;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerCatalog;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerConfigurationElements;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;

public final class ExtensionRegistryXmlSerializerCatalog
extends AbstractXmlSerializerCatalog {
    private static XmlSerializerCatalog _instance = null;
    private static final Object SHARED_INSTANCE_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlSerializerCatalog getInstance() {
        Object object = SHARED_INSTANCE_LOCK;
        synchronized (object) {
            if (_instance == null) {
                _instance = new ExtensionRegistryXmlSerializerCatalog();
            }
            return _instance;
        }
    }

    private ExtensionRegistryXmlSerializerCatalog() {
        this.loadXmlSerializerMappings();
        this.loadTagMappings();
        this.attachListener();
    }

    private void loadXmlSerializerMappings() {
        List<IConfigurationElement> list = XmlSerializerConfigurationElements.getSerializerConfigurationElements();
        this.addSerializerConfigurationElements(list);
    }

    private void addSerializerConfigurationElements(List<IConfigurationElement> list) {
        for (IConfigurationElement iConfigurationElement : list) {
            try {
                XmlSerializer xmlSerializer = XmlSerializerConfigurationElements.extractXmlSerializer(iConfigurationElement);
                List<String> list2 = XmlSerializerConfigurationElements.extractAppliesTo(iConfigurationElement);
                for (String string : list2) {
                    try {
                        try {
                            this.writeLock.lock();
                            Class<?> clazz = Class.forName(string);
                            this.xmlSerializerMap.put(clazz, xmlSerializer);
                        }
                        catch (Exception exception) {
                            System.err.println("unable to instantiate class " + string);
                            exception.printStackTrace();
                            this.writeLock.unlock();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        this.writeLock.unlock();
                        throw throwable;
                    }
                    this.writeLock.unlock();
                }
            }
            catch (Exception exception) {
                System.err.println("unable to load serializer for configuration element");
                exception.printStackTrace();
            }
        }
    }

    private void removeSerializerConfigurationElements(List<IConfigurationElement> list) {
        for (IConfigurationElement iConfigurationElement : list) {
            String string = XmlSerializerConfigurationElements.extractXmlSerializerClassName(iConfigurationElement);
            try {
                this.writeLock.lock();
                this.xmlSerializerMap.removeXmlSerializerByClassName(string);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private void loadTagMappings() {
        List<IConfigurationElement> list = XmlSerializerConfigurationElements.getTagConfigurationElements();
        this.addTagConfigurationElements(list);
    }

    private void addTagConfigurationElements(List<IConfigurationElement> list) {
        for (IConfigurationElement iConfigurationElement : list) {
            String string = iConfigurationElement.getAttribute("tag");
            String string2 = iConfigurationElement.getAttribute("mapsTo");
            try {
                try {
                    this.writeLock.lock();
                    Class<?> clazz = Class.forName(string2);
                    this.xmlTagMap.put(string, clazz);
                }
                catch (Exception exception) {
                    System.err.println("unable to instantiate class " + string2);
                    this.writeLock.unlock();
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
            this.writeLock.unlock();
        }
    }

    private void removeTagConfigurationElements(List<IConfigurationElement> list) {
        for (IConfigurationElement iConfigurationElement : list) {
            String string = iConfigurationElement.getAttribute("tag");
            try {
                this.writeLock.lock();
                this.xmlTagMap.removeTag(string);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private void attachListener() {
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryXmlSerializerCatalog.getExtensionRegistry();
        try {
            this.writeLock.lock();
            iExtensionRegistry.addListener((IRegistryEventListener)new ExtensionRegistryXmlSerializerCatalogListener(this), "com.ibm.arcs.serialization.xml.serializer");
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static IExtensionRegistry getExtensionRegistry() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        if (iExtensionRegistry == null) {
            throw new RuntimeException("Unable to locate Eclipse platform extension registry");
        }
        return iExtensionRegistry;
    }

    private class ExtensionRegistryXmlSerializerCatalogListener
    implements IRegistryEventListener {
        private final ExtensionRegistryXmlSerializerCatalog catalogManaged;

        private ExtensionRegistryXmlSerializerCatalogListener(ExtensionRegistryXmlSerializerCatalog extensionRegistryXmlSerializerCatalog2) {
            this.catalogManaged = extensionRegistryXmlSerializerCatalog2;
        }

        public void added(IExtension[] iExtensionArray) {
            IExtension[] iExtensionArray2 = iExtensionArray;
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension iExtension = iExtensionArray2[n2];
                List<IConfigurationElement> list = Arrays.asList(iExtension.getConfigurationElements());
                this.addSerializers(list);
                this.addTags(list);
                ++n2;
            }
        }

        private void addSerializers(List<IConfigurationElement> list) {
            List<IConfigurationElement> list2 = XmlSerializerConfigurationElements.getSerializerConfigurationElements(list);
            this.catalogManaged.addSerializerConfigurationElements(list2);
        }

        private void addTags(List<IConfigurationElement> list) {
            List<IConfigurationElement> list2 = XmlSerializerConfigurationElements.getTagConfigurationElements(list);
            this.catalogManaged.addTagConfigurationElements(list2);
        }

        public void removed(IExtension[] iExtensionArray) {
            IExtension[] iExtensionArray2 = iExtensionArray;
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension iExtension = iExtensionArray2[n2];
                List<IConfigurationElement> list = Arrays.asList(iExtension.getConfigurationElements());
                this.removeSerializers(list);
                this.removeTags(list);
                ++n2;
            }
        }

        private void removeSerializers(List<IConfigurationElement> list) {
            List<IConfigurationElement> list2 = XmlSerializerConfigurationElements.getSerializerConfigurationElements(list);
            this.catalogManaged.removeSerializerConfigurationElements(list2);
        }

        private void removeTags(List<IConfigurationElement> list) {
            List<IConfigurationElement> list2 = XmlSerializerConfigurationElements.getTagConfigurationElements(list);
            this.catalogManaged.removeTagConfigurationElements(list2);
        }

        public void added(IExtensionPoint[] iExtensionPointArray) {
        }

        public void removed(IExtensionPoint[] iExtensionPointArray) {
        }
    }
}

