/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.serialization.xml.catalog;

import com.ibm.arcs.serialization.xml.XmlSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class XmlSerializerConfigurationElements {
    public static final String serializerElementName = "serializer";
    public static final String idAttribute = "id";
    public static final String nameAttribute = "name";
    public static final String classAttribute = "class";
    public static final String priorityAttribute = "priority";
    public static final String tagElementName = "tag";
    public static final String tagAttribute = "tag";
    public static final String mapsToAttribute = "mapsTo";

    public static final List<XmlSerializer> getAllSerializers() throws CoreException {
        ArrayList<XmlSerializer> arrayList = new ArrayList<XmlSerializer>();
        List<IConfigurationElement> list = XmlSerializerConfigurationElements.getSerializerConfigurationElements();
        for (IConfigurationElement iConfigurationElement : list) {
            XmlSerializer xmlSerializer = null;
            xmlSerializer = XmlSerializerConfigurationElements.extractXmlSerializer(iConfigurationElement);
            if (xmlSerializer == null) continue;
            arrayList.add(xmlSerializer);
        }
        return arrayList;
    }

    public static final XmlSerializer getSerializerForClass(Class<?> clazz) throws CoreException {
        return XmlSerializerConfigurationElements.getSerializerForClassByName(clazz.getName());
    }

    public static final XmlSerializer getSerializerForClassByName(String string) throws CoreException {
        List<IConfigurationElement> list = XmlSerializerConfigurationElements.getSerializerConfigurationElementsForClassByName(string);
        if (list.size() == 0) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.serialization.xml", "no serializer exists for specified object"));
        }
        IConfigurationElement iConfigurationElement = XmlSerializerConfigurationElements.getHighestPrioritySerializer(list);
        return XmlSerializerConfigurationElements.extractXmlSerializer(iConfigurationElement);
    }

    public static final List<XmlSerializer> getSerializersForClass(Class<?> clazz) {
        ArrayList<XmlSerializer> arrayList = new ArrayList<XmlSerializer>();
        List<IConfigurationElement> list = XmlSerializerConfigurationElements.getSerializerConfigurationElementsForClass(clazz);
        for (IConfigurationElement iConfigurationElement : list) {
            try {
                XmlSerializer xmlSerializer = XmlSerializerConfigurationElements.extractXmlSerializer(iConfigurationElement);
                arrayList.add(xmlSerializer);
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    private static final List<IConfigurationElement> getSerializerConfigurationElementsForClass(Class<?> clazz) {
        String string = clazz.getName();
        return XmlSerializerConfigurationElements.getSerializerConfigurationElementsForClassByName(string);
    }

    private static final List<IConfigurationElement> getSerializerConfigurationElementsForClassByName(String string) {
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        List<IConfigurationElement> list = XmlSerializerConfigurationElements.getSerializerConfigurationElements();
        for (IConfigurationElement iConfigurationElement : list) {
            List<String> list2 = XmlSerializerConfigurationElements.extractAppliesTo(iConfigurationElement);
            if (!list2.contains(string)) continue;
            arrayList.add(iConfigurationElement);
        }
        return arrayList;
    }

    public static final List<IConfigurationElement> getSerializerConfigurationElements() {
        return XmlSerializerConfigurationElements.getSerializerConfigurationElements(XmlSerializerConfigurationElements.getConfigurationElements());
    }

    public static final List<IConfigurationElement> getSerializerConfigurationElements(List<IConfigurationElement> list) {
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement iConfigurationElement : list) {
            if (!XmlSerializerConfigurationElements.isSerializerConfigurationElement(iConfigurationElement)) continue;
            arrayList.add(iConfigurationElement);
        }
        return arrayList;
    }

    public static final boolean isSerializerConfigurationElement(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getName();
        return string.equals(serializerElementName);
    }

    public static final List<IConfigurationElement> getTagConfigurationElements() {
        return XmlSerializerConfigurationElements.getTagConfigurationElements(XmlSerializerConfigurationElements.getConfigurationElements());
    }

    public static final List<IConfigurationElement> getTagConfigurationElements(List<IConfigurationElement> list) {
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement iConfigurationElement : list) {
            if (!XmlSerializerConfigurationElements.isTagConfigurationElement(iConfigurationElement)) continue;
            arrayList.add(iConfigurationElement);
        }
        return arrayList;
    }

    public static final boolean isTagConfigurationElement(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getName();
        return string.equals("tag");
    }

    public static final List<IConfigurationElement> getConfigurationElements() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        if (iExtensionRegistry == null) {
            throw new RuntimeException("Unable to locate Eclipse platform extension registry");
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("com.ibm.arcs.serialization.xml.serializer");
        return Arrays.asList(iConfigurationElementArray);
    }

    public static final XmlSerializer getSerializerById(String string) throws CoreException {
        return XmlSerializerConfigurationElements.extractXmlSerializer(XmlSerializerConfigurationElements.getSerializerConfigurationElementById(string));
    }

    private static final IConfigurationElement getSerializerConfigurationElementById(String string) {
        List<IConfigurationElement> list = XmlSerializerConfigurationElements.getSerializerConfigurationElements();
        for (IConfigurationElement iConfigurationElement : list) {
            if (!iConfigurationElement.getAttribute(idAttribute).equals(string)) continue;
            return iConfigurationElement;
        }
        throw new IllegalArgumentException("unable to locate serializer with id " + string);
    }

    public static final List<String> extractAppliesTo(IConfigurationElement iConfigurationElement) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
        ArrayList<String> arrayList = new ArrayList<String>(iConfigurationElementArray.length);
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[n2];
            String string = iConfigurationElement2.getAttribute(classAttribute);
            arrayList.add(string);
            ++n2;
        }
        return arrayList;
    }

    public static final XmlSerializer extractXmlSerializer(IConfigurationElement iConfigurationElement) throws CoreException {
        Object object = iConfigurationElement.createExecutableExtension(classAttribute);
        if (object instanceof XmlSerializer) {
            XmlSerializer xmlSerializer = (XmlSerializer)object;
            return xmlSerializer;
        }
        throw new IllegalArgumentException("class specified by serializer element is not an xml object serializer");
    }

    public static final String extractXmlSerializerClassName(IConfigurationElement iConfigurationElement) {
        return iConfigurationElement.getAttribute(classAttribute);
    }

    public static final int lookupPriority(String string) {
        List<IConfigurationElement> list = XmlSerializerConfigurationElements.getSerializerConfigurationElements();
        for (IConfigurationElement iConfigurationElement : list) {
            if (!iConfigurationElement.getAttribute(idAttribute).equals(string)) continue;
            return XmlSerializerConfigurationElements.extractPriority(iConfigurationElement);
        }
        throw new IllegalArgumentException("unable to locate " + string);
    }

    private static final int extractPriority(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute(priorityAttribute);
        if (string != null) {
            return Integer.parseInt(string);
        }
        throw new IllegalArgumentException("serializerElement specified does not have a priority");
    }

    private static IConfigurationElement getHighestPrioritySerializer(List<IConfigurationElement> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        Collections.sort(list, SerializerConfigurationElementPriorityComparator.instance);
        return list.get(0);
    }

    private static final class SerializerConfigurationElementPriorityComparator
    implements Comparator<IConfigurationElement> {
        public static final SerializerConfigurationElementPriorityComparator instance = new SerializerConfigurationElementPriorityComparator();

        private SerializerConfigurationElementPriorityComparator() {
        }

        @Override
        public int compare(IConfigurationElement iConfigurationElement, IConfigurationElement iConfigurationElement2) {
            int n = XmlSerializerConfigurationElements.extractPriority(iConfigurationElement);
            int n2 = XmlSerializerConfigurationElements.extractPriority(iConfigurationElement2);
            return n - n2;
        }
    }
}

