/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.serialization.xml.catalog;

import com.ibm.arcs.serialization.xml.XmlSerializer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class XmlSerializerMap {
    private final Map<Class<?>, XmlSerializer> map = new HashMap();

    public Set<Class<?>> getClasses() {
        return this.map.keySet();
    }

    public Set<XmlSerializer> getXmlSerializers() {
        HashSet<XmlSerializer> hashSet = new HashSet<XmlSerializer>();
        for (Class<?> clazz : this.getClasses()) {
            hashSet.add(this.map.get(clazz));
        }
        return hashSet;
    }

    public void clear() {
        this.map.clear();
    }

    public void put(Class<?> clazz, XmlSerializer xmlSerializer) {
        this.map.put(clazz, xmlSerializer);
    }

    public XmlSerializer getXmlSerializer(Class<?> clazz) {
        return this.map.get(clazz);
    }

    public XmlSerializer getXmlSerializerForClassByName(String string) {
        for (Class<?> clazz : this.map.keySet()) {
            if (!clazz.getName().equals(string)) continue;
            return this.map.get(clazz);
        }
        return null;
    }

    public Set<Class<?>> getClasses(XmlSerializer xmlSerializer) {
        HashSet hashSet = new HashSet();
        for (Class<?> clazz : this.map.keySet()) {
            if (!this.map.get(clazz).equals(xmlSerializer)) continue;
            hashSet.add(clazz);
        }
        return hashSet;
    }

    public void removeClass(Class<?> clazz) {
        this.map.remove(clazz);
    }

    private void removeClasses(Set<Class<?>> set) {
        for (Class<?> clazz : set) {
            this.map.remove(clazz);
        }
    }

    public void removeXmlSerializer(XmlSerializer xmlSerializer) {
        Set<Class<?>> set = this.getClasses(xmlSerializer);
        this.removeClasses(set);
    }

    public void removeXmlSerializerByClassName(String string) {
        Set<Class<?>> set = this.getClassesForXmlSerializerByClassName(string);
        this.removeClasses(set);
    }

    private Set<Class<?>> getClassesForXmlSerializerByClassName(String string) {
        HashSet hashSet = new HashSet();
        for (Class<?> clazz : this.map.keySet()) {
            if (!this.map.get(clazz).getClass().getName().equals(string)) continue;
            hashSet.add(clazz);
        }
        return hashSet;
    }
}

