/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.serialization.xml.serializer;

import com.ibm.arcs.basic.parameter.ImmutableParameter;
import com.ibm.arcs.basic.parameter.Parameter;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.serialization.xml.AbstractXmlSerializer;
import com.ibm.arcs.serialization.xml.XmlSerializer;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerCatalog;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerConfigurationElements;
import org.eclipse.core.runtime.CoreException;

public class ObjectSerializer
extends AbstractXmlSerializer {
    public static final String OBJECT_TAG = "object";
    public static final String CLASS_TAG = "class";

    @Override
    public boolean accepts(Class<?> clazz) {
        return true;
    }

    @Override
    public HierarchicalParameter toHierarchicalParameter(Object object, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        XmlSerializer xmlSerializer = XmlSerializerConfigurationElements.getSerializerForClass(object.getClass());
        return xmlSerializer.toHierarchicalParameter(object, xmlSerializerCatalog);
    }

    @Override
    public Object fromXml(HierarchicalParameter hierarchicalParameter, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        String string = ObjectSerializer.extractClassName(hierarchicalParameter);
        XmlSerializer xmlSerializer = XmlSerializerConfigurationElements.getSerializerForClassByName(string);
        return xmlSerializer.fromXml(hierarchicalParameter, xmlSerializerCatalog);
    }

    private static HierarchicalParameter createSkeletonHierarchicalParameter(String string) {
        HierarchicalParameter hierarchicalParameter = new HierarchicalParameter(OBJECT_TAG);
        hierarchicalParameter.addAttribute((Parameter)new ImmutableParameter(CLASS_TAG, string));
        return hierarchicalParameter;
    }

    public static HierarchicalParameter createSkeletonHierarchicalParameter(String string, String string2) {
        HierarchicalParameter hierarchicalParameter = new HierarchicalParameter(OBJECT_TAG, string2);
        hierarchicalParameter.addAttribute((Parameter)new ImmutableParameter(CLASS_TAG, string));
        return hierarchicalParameter;
    }

    public static String getRootNodeTag(Class<?> clazz, XmlSerializerCatalog xmlSerializerCatalog) {
        String string = xmlSerializerCatalog.getTagForClass(clazz);
        if (string == null) {
            return OBJECT_TAG;
        }
        return string;
    }

    public static HierarchicalParameter createRootNode(Class<?> clazz, String string, XmlSerializerCatalog xmlSerializerCatalog) {
        String string2 = xmlSerializerCatalog.getTagForClass(clazz);
        HierarchicalParameter hierarchicalParameter = string2 != null ? new HierarchicalParameter(string2, string) : ObjectSerializer.createSkeletonHierarchicalParameter(clazz.getName(), string);
        return hierarchicalParameter;
    }

    public static HierarchicalParameter createRootNode(Class<?> clazz, XmlSerializerCatalog xmlSerializerCatalog) {
        String string = xmlSerializerCatalog.getTagForClass(clazz);
        HierarchicalParameter hierarchicalParameter = string != null ? new HierarchicalParameter(string) : ObjectSerializer.createSkeletonHierarchicalParameter(clazz.getName());
        return hierarchicalParameter;
    }

    private static final String extractClassName(HierarchicalParameter hierarchicalParameter) {
        return hierarchicalParameter.getAttribute(CLASS_TAG).getValue();
    }
}

