/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.serialization.xml.serializer.number;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.serialization.xml.AbstractXmlSerializer;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerCatalog;
import com.ibm.arcs.serialization.xml.serializer.ObjectSerializer;
import java.math.BigInteger;

public class BigIntegerXmlSerializer
extends AbstractXmlSerializer {
    private static final String ID = "java.lang.BigInteger";

    @Override
    public boolean accepts(Class<?> clazz) {
        return clazz.equals(BigInteger.class);
    }

    @Override
    public HierarchicalParameter toHierarchicalParameter(Object object, XmlSerializerCatalog xmlSerializerCatalog) {
        if (this.accepts(object.getClass())) {
            BigInteger bigInteger = (BigInteger)object;
            return ObjectSerializer.createSkeletonHierarchicalParameter(ID, bigInteger.toString());
        }
        throw new IllegalArgumentException("unsupported object type");
    }

    @Override
    public Object fromXml(HierarchicalParameter hierarchicalParameter, XmlSerializerCatalog xmlSerializerCatalog) {
        if (!hierarchicalParameter.getKey().equals("object")) {
            throw new IllegalArgumentException("not an xml serializable object");
        }
        if (!hierarchicalParameter.getAttribute("class").getValue().equals(ID)) {
            throw new IllegalArgumentException("not an xml serializable BigInteger");
        }
        return new BigInteger(hierarchicalParameter.getValue());
    }
}

