/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.status.ui.widgets;

import com.ibm.arcs.basic.strings.StringUtils;
import com.ibm.arcs.status.ui.AbstractStatusPublishingText;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

public class BasicValidatedNumericText
extends AbstractStatusPublishingText {
    private boolean acceptNullInput = false;

    public BasicValidatedNumericText(Composite composite, int n) {
        super(composite, n);
        this.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                BasicValidatedNumericText.this.verifyAndPublishStatus();
            }
        });
    }

    public void setAcceptNullInput(boolean bl) {
        this.acceptNullInput = bl;
    }

    public IStatus getStatus() {
        if (!this.acceptNullInput && this.getText().length() == 0) {
            return new Status(4, "com.ibm.arcs.status.ui", 32, "input is required", null);
        }
        if (!StringUtils.containsAllDigits((String)this.getText())) {
            return new Status(4, "com.ibm.arcs.status.ui", 32, "input must contain only digits", null);
        }
        return Status.OK_STATUS;
    }

    public int getValue() {
        if (this.isValid()) {
            return Integer.parseInt(this.getText());
        }
        throw new IllegalArgumentException("user input is a valid integer");
    }

    public void setValue(int n) {
        this.setText(Integer.toString(n));
    }

    @Override
    public boolean isValid() {
        return this.getStatus().isOK();
    }
}

