/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.status.ui.widgets;

import com.ibm.arcs.basic.strings.StringUtils;
import com.ibm.arcs.status.ui.AbstractStatusPublishingText;
import com.ibm.arcs.status.ui.widgets.IValidatedTextField;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

public class BasicValidatedText
extends AbstractStatusPublishingText
implements IValidatedTextField {
    private boolean acceptInputWithSpaces = false;
    private boolean acceptNullInput = false;

    public BasicValidatedText(Composite composite, int n) {
        super(composite, n);
        this.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                BasicValidatedText.this.verifyAndPublishStatus();
            }
        });
    }

    public void setAcceptInputWithSpaces(boolean bl) {
        this.acceptInputWithSpaces = bl;
    }

    public void setAcceptNullInput(boolean bl) {
        this.acceptNullInput = bl;
    }

    @Override
    protected void checkSubclass() {
    }

    public IStatus getStatus() {
        if (!this.acceptNullInput && this.getText().length() == 0) {
            return new Status(4, "com.ibm.arcs.status.ui", 32, "input is required", null);
        }
        if (!this.acceptInputWithSpaces && StringUtils.containsSpaces((String)this.getText())) {
            return new Status(4, "com.ibm.arcs.status.ui", 32, "cannot contain spaces", null);
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean isValid() {
        return !StringUtils.containsSpaces((String)this.getText());
    }
}

