/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.status.group;

import com.ibm.arcs.status.forward.AllStatusForwarder;
import com.ibm.arcs.status.forward.IStatusForwarder;
import com.ibm.arcs.status.group.IGroupStatusPublisher;
import com.ibm.arcs.status.listener.IStatusListener;
import com.ibm.arcs.status.publish.IStatusPublisher;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;

public class GroupStatusPublisher
implements IGroupStatusPublisher {
    protected IStatusForwarder forwarder;
    protected final Set<IStatusPublisher> statusPublishers = new HashSet<IStatusPublisher>();

    public GroupStatusPublisher() {
        this.forwarder = new AllStatusForwarder();
    }

    @Override
    public boolean addStatusPublisher(IStatusPublisher iStatusPublisher) {
        boolean bl = this.statusPublishers.add(iStatusPublisher);
        if (bl) {
            iStatusPublisher.addStatusListener(this.forwarder);
        }
        return bl;
    }

    @Override
    public boolean removeStatusPublisher(IStatusPublisher iStatusPublisher) {
        boolean bl = this.statusPublishers.remove(iStatusPublisher);
        if (bl) {
            iStatusPublisher.removeStatusListener(this.forwarder);
        }
        return bl;
    }

    @Override
    public Set<IStatusPublisher> getStatusPublishers() {
        return Collections.unmodifiableSet(this.statusPublishers);
    }

    @Override
    public boolean addStatusListener(IStatusListener iStatusListener) {
        return this.forwarder.addStatusListener(iStatusListener);
    }

    @Override
    public boolean removeStatusListener(IStatusListener iStatusListener) {
        return this.forwarder.removeStatusListener(iStatusListener);
    }

    @Override
    public Set<IStatusListener> getStatusListeners() {
        return this.forwarder.getStatusListeners();
    }

    protected void publishStatus(IStatus iStatus) {
        this.forwarder.publishStatus(iStatus);
    }
}

