/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.status.group;

import com.ibm.arcs.status.IStatusProvider;
import com.ibm.arcs.status.forward.CurrentStatusForwarder;
import com.ibm.arcs.status.group.GroupStatusPublisher;
import com.ibm.arcs.status.publish.IStatusPublisher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GroupStatusPublishingProvider
extends GroupStatusPublisher
implements IStatusProvider {
    private static final int[] STATUS_SEVERITY_ORDERED;
    private final IStatusProvider groupStatusProvider = new GroupStatusProvider();

    static {
        int[] nArray = new int[5];
        nArray[0] = 4;
        nArray[1] = 2;
        nArray[2] = 1;
        nArray[3] = 8;
        STATUS_SEVERITY_ORDERED = nArray;
    }

    public GroupStatusPublishingProvider() {
        this.forwarder = new CurrentStatusForwarder(this.groupStatusProvider);
    }

    @Override
    public boolean addStatusPublisher(IStatusPublisher iStatusPublisher) {
        if (iStatusPublisher instanceof IStatusProvider) {
            return super.addStatusPublisher(iStatusPublisher);
        }
        throw new IllegalArgumentException("specified IStatusPublisher is not an IStatusProvider");
    }

    public Set<IStatusProvider> getStatusProviders() {
        HashSet<IStatusProvider> hashSet = new HashSet<IStatusProvider>(this.statusPublishers.size());
        for (IStatusPublisher iStatusPublisher : this.statusPublishers) {
            hashSet.add((IStatusProvider)((Object)iStatusPublisher));
        }
        return hashSet;
    }

    @Override
    public IStatus getStatus() {
        return this.groupStatusProvider.getStatus();
    }

    private class GroupStatusProvider
    implements IStatusProvider {
        private GroupStatusProvider() {
        }

        @Override
        public IStatus getStatus() {
            List<IStatus> list = this.getAllPublishersStatus();
            int[] nArray = STATUS_SEVERITY_ORDERED;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                List<IStatus> list2 = this.extractStatusesWithSeverity(list, n3);
                if (list2.size() > 0) {
                    return this.getHighestPriorityStatus(list2);
                }
                ++n2;
            }
            if (list.size() > 0) {
                throw new RuntimeException("Fatal Error: No status matched any severity being searched for even though all severities are defined");
            }
            return Status.OK_STATUS;
        }

        private List<IStatus> extractStatusesWithSeverity(List<IStatus> list, int n) {
            ArrayList<IStatus> arrayList = new ArrayList<IStatus>();
            for (IStatus iStatus : list) {
                if (iStatus.getSeverity() != n) continue;
                arrayList.add(iStatus);
            }
            return arrayList;
        }

        private IStatus getHighestPriorityStatus(List<IStatus> list) {
            TreeMap<Integer, IStatus> treeMap = new TreeMap<Integer, IStatus>();
            for (IStatus iStatus : list) {
                treeMap.put(this.extractPriority(iStatus), iStatus);
            }
            return (IStatus)treeMap.firstEntry().getValue();
        }

        private Integer extractPriority(IStatus iStatus) {
            return iStatus.getCode();
        }

        public List<IStatus> getAllPublishersStatus() {
            ArrayList<IStatus> arrayList = new ArrayList<IStatus>(GroupStatusPublishingProvider.this.statusPublishers.size());
            for (IStatusProvider iStatusProvider : GroupStatusPublishingProvider.this.getStatusProviders()) {
                arrayList.add(iStatusProvider.getStatus());
            }
            return arrayList;
        }
    }
}

