/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.status.listener;

import com.ibm.arcs.status.listener.IStatusListener;
import com.ibm.arcs.status.listener.IStatusListenerGroup;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;

public class StatusListenerGroup
implements IStatusListenerGroup {
    protected final Set<IStatusListener> statusListeners = new HashSet<IStatusListener>();

    @Override
    public void publishStatus(IStatus iStatus) {
        for (IStatusListener iStatusListener : this.statusListeners) {
            iStatusListener.handleStatusUpdate(iStatus);
        }
    }

    @Override
    public boolean addStatusListener(IStatusListener iStatusListener) {
        boolean bl = this.statusListeners.add(iStatusListener);
        return bl;
    }

    @Override
    public boolean removeStatusListener(IStatusListener iStatusListener) {
        boolean bl = this.statusListeners.remove(iStatusListener);
        return bl;
    }

    @Override
    public Set<IStatusListener> getStatusListeners() {
        return Collections.unmodifiableSet(this.statusListeners);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("StatusListenerGroup [statusListeners=");
        stringBuilder.append(this.statusListeners);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

