/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.windows.registry;

import com.ibm.arcs.windows.registry.RegistryAction;
import com.ibm.arcs.windows.registry.RegistryModifier;
import com.ibm.arcs.windows.registry.RegistryParameter;
import com.ibm.arcs.windows.registry.RegistryPath;
import com.ibm.arcs.windows.registry.RegistryRoot;
import java.util.Arrays;
import java.util.Vector;

public class RegistryCommand {
    private final RegistryAction regAction;
    private final RegistryModifier[] regMods;
    private final RegistryRoot regRoot;
    private final RegistryPath regPath;
    public Vector<RegistryParameter> parameters;

    public RegistryCommand(RegistryAction registryAction, RegistryRoot registryRoot, RegistryPath registryPath) {
        this.regAction = registryAction;
        this.regMods = registryAction.getQueryModifiers();
        this.regRoot = registryRoot;
        this.regPath = registryPath;
        this.parameters = new Vector();
    }

    public String getCommand() {
        String string = new String();
        String string2 = " ";
        for (RegistryParameter registryParameter : this.parameters) {
            string = String.valueOf(string) + registryParameter + string2;
        }
        return (String.valueOf(this.regAction.getActionCommand()) + "\"" + this.regRoot.toString() + "\\" + this.regPath.toString() + "\" " + string).trim();
    }

    public RegistryModifier[] getAvailableMods() {
        return this.regMods;
    }

    RegistryPath getPath() {
        return this.regPath;
    }

    RegistryRoot getRoot() {
        return this.regRoot;
    }

    RegistryAction getAction() {
        return this.regAction;
    }

    public static void main(String[] stringArray) {
        RegistryAction registryAction = RegistryAction.Query;
        RegistryRoot registryRoot = RegistryRoot.HKEY_LOCAL_MACHINE;
        RegistryPath registryPath = null;
        try {
            registryPath = new RegistryPath("Software\\Informix\\SQLHosts", registryRoot);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        RegistryCommand registryCommand = new RegistryCommand(registryAction, registryRoot, registryPath);
        System.out.println(registryCommand.getCommand());
        RegistryModifier[] registryModifierArray = registryCommand.getAvailableMods();
        int n = registryModifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            RegistryModifier registryModifier = registryModifierArray[n2];
            System.out.println("Modification Name: " + registryModifier.toString() + "\nModification Command: " + registryModifier.getModifierCommand());
            ++n2;
        }
        int n3 = Arrays.binarySearch((Object[])registryCommand.getAvailableMods(), (Object)RegistryModifier.KeyName);
        System.out.println(RegistryModifier.KeyName.getNeedsValue());
        System.out.println(registryCommand.getCommand());
    }
}

