/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.windows.registry;

import com.ibm.arcs.windows.registry.IRegistryType;
import com.ibm.arcs.windows.registry.RegistryValue;
import com.ibm.arcs.windows.registry.RegistryValueDataType;

public class RegistryDoubleWord
implements IRegistryType {
    static final RegistryValueDataType type = RegistryValueDataType.REG_DWORD;
    private static RegistryDoubleWord registryDoubleWord = null;

    private RegistryDoubleWord() {
    }

    public static IRegistryType getInstance() {
        if (registryDoubleWord == null) {
            registryDoubleWord = new RegistryDoubleWord();
        }
        return registryDoubleWord;
    }

    private String convert(String string) {
        Integer n = Integer.parseInt(string);
        return Integer.toHexString(n);
    }

    @Override
    public void convertToType(RegistryValue registryValue) throws Exception {
        if (registryValue.getOriginalType() == type) {
            registryValue.setValue(registryValue.getOriginalValue());
        } else {
            registryValue.setValue("0x" + this.convert(registryValue.getOriginalValue()));
        }
    }

    @Override
    public RegistryValueDataType getType() {
        return type;
    }

    @Override
    public boolean valueCanBeThisType(String string) throws Exception {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        catch (Exception exception) {
            throw exception;
        }
        return true;
    }
}

