/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.windows.registry;

import com.ibm.arcs.windows.registry.RegistryAction;
import com.ibm.arcs.windows.registry.RegistryRoot;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class RegistryPath {
    private final String registryPath;
    private RegistryRoot registryRoot;

    public RegistryPath(String string, RegistryRoot registryRoot) throws Exception {
        if (!this.validatePath(string, registryRoot)) {
            throw new Exception("This path (" + string + ") is not recognized on root (" + registryRoot.toString() + ")");
        }
        this.registryPath = string;
        this.registryRoot = registryRoot;
    }

    public RegistryRoot getValidationRoot() {
        return this.registryRoot;
    }

    public void setValidationRoot(RegistryRoot registryRoot) {
        this.registryRoot = registryRoot;
    }

    private boolean validatePath(String string, RegistryRoot registryRoot) {
        boolean bl = false;
        try {
            String string2 = String.valueOf(RegistryAction.Query.getActionCommand()) + "\"" + registryRoot.toString() + "\\" + string + "\"";
            Process process = Runtime.getRuntime().exec(string2);
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            if (bufferedReader.readLine() != null) {
                bl = true;
            }
            bufferedReader.close();
            inputStreamReader.close();
        }
        catch (IOException iOException) {}
        return bl;
    }

    public String toString() {
        return this.registryPath;
    }

    public static void main(String[] stringArray) {
        try {
            new RegistryPath("Software\\Informix", RegistryRoot.HKEY_LOCAL_MACHINE);
            new RegistryPath("Software\\Informix\\SQLHosts", RegistryRoot.HKEY_LOCAL_MACHINE);
            new RegistryPath("Software\\Informix\\SQLHosts\\ids0", RegistryRoot.HKEY_LOCAL_MACHINE);
            new RegistryPath("Software\\Informix\\WillNotWork", RegistryRoot.HKEY_LOCAL_MACHINE);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

