/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.windows.registry;

import com.ibm.arcs.windows.registry.IRegistryType;
import com.ibm.arcs.windows.registry.RegistryDoubleWord;
import com.ibm.arcs.windows.registry.RegistryValue;
import com.ibm.arcs.windows.registry.RegistryValueDataType;

public class RegistryString
implements IRegistryType {
    private static final RegistryValueDataType type = RegistryValueDataType.REG_SZ;
    private static RegistryString registryString = null;

    private RegistryString() {
    }

    public static IRegistryType getInstance() {
        if (registryString == null) {
            registryString = new RegistryString();
        }
        return registryString;
    }

    private String convertFromDoubleWord(String string) {
        return Integer.toString(Integer.parseInt(string, 16));
    }

    @Override
    public void convertToType(RegistryValue registryValue) throws Exception {
        if (registryValue.getOriginalType() == type) {
            registryValue.setValue(registryValue.getOriginalValue());
        } else if (registryValue.getOriginalType() == RegistryDoubleWord.type) {
            registryValue.setValue(this.convertFromDoubleWord(registryValue.getOriginalValue().substring(2)));
        } else {
            registryValue.setValue(registryValue.getOriginalValue());
        }
    }

    @Override
    public RegistryValueDataType getType() {
        return type;
    }

    @Override
    public boolean valueCanBeThisType(String string) throws Exception {
        return true;
    }
}

