/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.windows.registry;

import com.ibm.arcs.basic.tuple.ImmutablePair;
import com.ibm.arcs.windows.registry.IRegistryType;
import com.ibm.arcs.windows.registry.RegistryAction;
import com.ibm.arcs.windows.registry.RegistryCommand;
import com.ibm.arcs.windows.registry.RegistryKey;
import com.ibm.arcs.windows.registry.RegistryPath;
import com.ibm.arcs.windows.registry.RegistryRoot;
import com.ibm.arcs.windows.registry.RegistryValue;
import com.ibm.arcs.windows.registry.RegistryValueDataType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Vector;

public class WindowsRegistryReader {
    private static WindowsRegistryReader reader = null;

    private WindowsRegistryReader() {
    }

    public static WindowsRegistryReader getInstance() {
        if (reader == null) {
            reader = new WindowsRegistryReader();
        }
        return reader;
    }

    public synchronized RegistryKey readValues(RegistryCommand registryCommand) {
        if (registryCommand.getPath().toString().contains("(Common)")) {
            return null;
        }
        if (registryCommand.getAction() != RegistryAction.Query) {
            throw new IllegalArgumentException("Reader only allows query command actions.");
        }
        Vector<ImmutablePair<IRegistryType, RegistryValue>> vector = new Vector<ImmutablePair<IRegistryType, RegistryValue>>();
        try {
            String string;
            Process process = Runtime.getRuntime().exec(registryCommand.getCommand());
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                if (string.contains("!") || string.contains(registryCommand.getPath().toString()) || string.isEmpty()) continue;
                String[] stringArray = new String[3];
                String[] stringArray2 = string.trim().split("\\s+", 3);
                int n = 0;
                while (n < stringArray2.length) {
                    stringArray[n] = stringArray2[n];
                    ++n;
                }
                RegistryValueDataType registryValueDataType = RegistryValueDataType.valueOf(stringArray[1]);
                RegistryValue registryValue = new RegistryValue(stringArray[0], stringArray[2], registryValueDataType);
                vector.addElement((ImmutablePair<IRegistryType, RegistryValue>)new ImmutablePair((Object)registryValueDataType.getType(), (Object)registryValue));
            }
            bufferedReader.close();
            inputStreamReader.close();
        }
        catch (IOException iOException) {}
        return new RegistryKey(registryCommand.getPath(), vector, null, null);
    }

    public synchronized RegistryKey readKeys(RegistryCommand registryCommand) {
        if (registryCommand.getAction() != RegistryAction.Query) {
            throw new IllegalArgumentException("Reader only allows query command actions.");
        }
        Vector<RegistryKey> vector = new Vector<RegistryKey>();
        try {
            String string;
            Process process = Runtime.getRuntime().exec(registryCommand.getCommand());
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if (string.contains("!") || string.isEmpty() || (n = string.indexOf(String.valueOf(registryCommand.getPath().toString()) + '\\')) == -1) continue;
                int n2 = n + registryCommand.getPath().toString().length() + 1;
                String string2 = string.substring(n2).trim();
                vector.add(new RegistryKey(new RegistryPath(String.valueOf(registryCommand.getPath().toString()) + '\\' + string2, registryCommand.getRoot()), null, null, null));
            }
            bufferedReader.close();
            inputStreamReader.close();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {}
        return new RegistryKey(registryCommand.getPath(), null, vector, null);
    }

    public synchronized RegistryKey readTree(RegistryCommand registryCommand) {
        RegistryKey registryKey = this.readKeys(registryCommand);
        RegistryKey registryKey2 = this.readValues(registryCommand);
        RegistryKey registryKey3 = new RegistryKey(registryCommand.getPath(), registryKey2.getTypedValues(), registryKey.getSubKeys(), null);
        for (RegistryKey registryKey4 : registryKey3.getSubKeys()) {
            this.buildTree(registryKey4, registryKey3, registryCommand.getRoot(), registryCommand.getAction());
        }
        return registryKey3;
    }

    private void buildTree(RegistryKey registryKey, RegistryKey registryKey2, RegistryRoot registryRoot, RegistryAction registryAction) {
        RegistryCommand registryCommand = new RegistryCommand(registryAction, registryRoot, registryKey.getKeyPath());
        registryKey.setSubKeys(this.readKeys(registryCommand).getSubKeys());
        try {
            registryKey.setTypedValues(this.readValues(registryCommand).getTypedValues());
        }
        catch (NullPointerException nullPointerException) {
            registryKey.setTypedValues(null);
        }
        for (RegistryKey registryKey3 : registryKey.getSubKeys()) {
            this.buildTree(registryKey3, registryKey, registryRoot, registryAction);
        }
    }

    private void printTree(RegistryKey registryKey, int n) {
        try {
            for (ImmutablePair<IRegistryType, RegistryValue> object : registryKey.getTypedValues()) {
                RegistryValue registryValue = (RegistryValue)object.getSecond();
                System.out.println(String.valueOf(IndentString.getIndentString(n + 1)) + registryValue.getName() + '\t' + (Object)((Object)registryValue.getOriginalType()) + '\t' + registryValue.getValue());
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Could not read further down the tree here.  Parent path must have errors in it.");
        }
        if (registryKey.getSubKeys() != null) {
            for (RegistryKey registryKey2 : registryKey.getSubKeys()) {
                System.out.println(String.valueOf(IndentString.getIndentString(n)) + registryKey2.getKeyName());
                this.printTree(registryKey2, n + 1);
            }
        }
    }

    static class IndentString {
        static final ArrayList<String> indentStrings = new ArrayList();

        IndentString() {
        }

        public static String getIndentString(int n) {
            if (n + 1 > indentStrings.size()) {
                IndentString.increaseIndentStringCache(n);
            }
            return indentStrings.get(n);
        }

        private static String createIndentString(int n) {
            String string = new String();
            int n2 = 0;
            while (n2 < n) {
                string = String.valueOf(string) + '-';
                ++n2;
            }
            return string;
        }

        private static void increaseIndentStringCache(int n) {
            int n2 = n + 1;
            int n3 = indentStrings.size();
            while (n3 < n2) {
                indentStrings.add(IndentString.createIndentString(n3));
                ++n3;
            }
        }
    }
}

