/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.xmlobject;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.basic.strings.IStringMatcher;
import com.ibm.arcs.basic.strings.StringMatcherExact;
import com.ibm.arcs.xmlobject.XmlObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;

public abstract class AbstractXmlObject
implements XmlObject {
    private final String id;
    private XmlObject parent;
    private final List<XmlObject> children = new ArrayList<XmlObject>();
    private final IStringMatcher typeMatcher;

    public AbstractXmlObject(String string) {
        this.id = string;
        this.parent = null;
        this.typeMatcher = new StringMatcherExact(this.id);
    }

    public AbstractXmlObject(XmlObject xmlObject, XmlObject xmlObject2) {
        this.id = xmlObject2.getId();
        this.parent = xmlObject;
        this.typeMatcher = new StringMatcherExact(this.id);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IStringMatcher getTypeMatcher() {
        return this.typeMatcher;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public XmlObject getParent() {
        return this.parent;
    }

    public void setParent(XmlObject xmlObject) {
        if (!this.isAddableToNodeHierarchy(xmlObject)) {
            throw new IllegalArgumentException("cannot set parent");
        }
        this.unsetParent();
        this.attachToParent(xmlObject);
    }

    public void unsetParent() {
        if (this.isRemovableFromNodeHierarchy()) {
            if (this.hasParent()) {
                XmlObject xmlObject = this.parent;
                this.parent = null;
                xmlObject.removeChildUnchecked(this);
            }
        } else {
            throw new IllegalArgumentException("cannot unset parent");
        }
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int getNumberOfChildren() {
        return this.children.size();
    }

    public List<XmlObject> getChildren() {
        return this.children;
    }

    public XmlObject getChild(int n) {
        return this.children.get(n);
    }

    public void addChild(XmlObject xmlObject) {
        xmlObject.setParent(this);
    }

    @Override
    public void addChildUnchecked(XmlObject xmlObject) {
        if (xmlObject.getParent() != this) {
            throw new IllegalArgumentException("child's parent is not set to be this");
        }
        this.children.add(xmlObject);
    }

    public void removeChild(XmlObject xmlObject) {
        xmlObject.unsetParent();
    }

    @Override
    public void removeChildUnchecked(XmlObject xmlObject) {
        if (xmlObject.hasParent()) {
            throw new IllegalArgumentException("attempt to remove child that still parent set");
        }
        this.children.remove(xmlObject);
    }

    private void attachToParent(XmlObject xmlObject) {
        this.parent = xmlObject;
        this.parent.addChildUnchecked(this);
    }

    public XmlObject getRoot() {
        XmlObject xmlObject = this;
        while (xmlObject.getParent() != null) {
            xmlObject = (XmlObject)xmlObject.getParent();
        }
        return xmlObject;
    }

    @Override
    public HierarchicalParameter toHierarchicalParameterRecursive() throws CoreException {
        if (!this.isValid()) {
            return null;
        }
        return AbstractXmlObject.toHierarchicalParameterRecursiveInternal(this);
    }

    private static HierarchicalParameter toHierarchicalParameterRecursiveInternal(XmlObject xmlObject) throws CoreException {
        HierarchicalParameter hierarchicalParameter = xmlObject.toHierarchicalParameter();
        for (XmlObject xmlObject2 : xmlObject.getChildren()) {
            hierarchicalParameter.addChild(AbstractXmlObject.toHierarchicalParameterRecursiveInternal(xmlObject2));
        }
        return hierarchicalParameter;
    }

    public boolean isValidRecursive() {
        if (!this.isValid()) {
            return false;
        }
        if (this.hasChildren()) {
            for (XmlObject xmlObject : this.getChildren()) {
                if (xmlObject.isValidRecursive()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isAddableToNodeHierarchy(XmlObject xmlObject) {
        return true;
    }

    public boolean isRemovableFromNodeHierarchy() {
        return true;
    }
}

