/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.xmlobject.impl;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.serialization.xml.serializer.ObjectSerializer;
import com.ibm.arcs.xmlobject.AbstractXmlObject;

public class BooleanXmlObject
extends AbstractXmlObject {
    private static final String POINT_ID = "java.lang.Boolean";
    private final Boolean value;

    public BooleanXmlObject(Boolean bl) {
        super(POINT_ID);
        this.value = bl;
    }

    public Boolean getValue() {
        return this.value;
    }

    @Override
    public HierarchicalParameter toHierarchicalParameter() {
        return BooleanXmlObject.toHierarchicalParameter(this.value);
    }

    @Override
    public Boolean toObject() {
        return this.value;
    }

    public static HierarchicalParameter toHierarchicalParameter(Boolean bl) {
        return ObjectSerializer.createSkeletonHierarchicalParameter((String)POINT_ID, (String)bl.toString());
    }

    public static Boolean valueOf(HierarchicalParameter hierarchicalParameter) {
        if (!hierarchicalParameter.getKey().equals("object")) {
            throw new IllegalArgumentException("not an xml serializable object");
        }
        if (!hierarchicalParameter.getAttribute("class").equals(POINT_ID)) {
            throw new IllegalArgumentException("not an xml serializable boolean");
        }
        return Boolean.parseBoolean(hierarchicalParameter.getValue());
    }
}

