/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.xmlobject.impl;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.serialization.xml.serializer.ObjectSerializer;
import com.ibm.arcs.xmlobject.AbstractXmlObject;

public class IntegerXmlObject
extends AbstractXmlObject {
    private static final String POINT_ID = "java.lang.Integer";
    private final Integer value;

    public IntegerXmlObject(Integer n) {
        super(POINT_ID);
        this.value = n;
    }

    public Integer getValue() {
        return this.value;
    }

    @Override
    public HierarchicalParameter toHierarchicalParameter() {
        return IntegerXmlObject.toHierarchicalParameter(this.value);
    }

    @Override
    public Integer toObject() {
        return this.value;
    }

    public static HierarchicalParameter toHierarchicalParameter(Integer n) {
        return ObjectSerializer.createSkeletonHierarchicalParameter((String)POINT_ID, (String)n.toString());
    }

    public static Integer valueOf(HierarchicalParameter hierarchicalParameter) {
        if (!hierarchicalParameter.getKey().equals("object")) {
            throw new IllegalArgumentException("not an xml serializable object");
        }
        if (!hierarchicalParameter.getAttribute("class").equals(POINT_ID)) {
            throw new IllegalArgumentException("not an xml serializable integer");
        }
        return Integer.parseInt(hierarchicalParameter.getValue());
    }
}

