/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.xmlobject.impl;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.serialization.xml.serializer.ObjectSerializer;
import com.ibm.arcs.xmlobject.AbstractXmlObject;
import com.ibm.arcs.xmlobject.impl.StringXmlObject;
import java.util.ArrayList;
import java.util.List;

public class ListStringXmlObject
extends AbstractXmlObject {
    private static final String POINT_ID = "java.util.List";
    public static final String ENTRY_TAG = "entry";
    private final List<String> strings;

    public ListStringXmlObject(List<String> list) {
        super(POINT_ID);
        this.strings = list;
    }

    public List<String> getValue() {
        return this.strings;
    }

    @Override
    public HierarchicalParameter toHierarchicalParameter() {
        return ListStringXmlObject.toHierarchicalParameter(this.strings);
    }

    @Override
    public List<String> toObject() {
        return this.strings;
    }

    public static HierarchicalParameter toHierarchicalParameter(List<String> list) {
        HierarchicalParameter hierarchicalParameter = ObjectSerializer.createSkeletonHierarchicalParameter((String)POINT_ID, null);
        for (String string : list) {
            hierarchicalParameter.addChild(StringXmlObject.toHierarchicalParameter(string));
        }
        return hierarchicalParameter;
    }

    public static List<String> valueOf(HierarchicalParameter hierarchicalParameter) {
        if (!hierarchicalParameter.getKey().equals("object")) {
            throw new IllegalArgumentException("not an xml serializable object");
        }
        if (!hierarchicalParameter.getAttribute("class").equals(POINT_ID)) {
            throw new IllegalArgumentException("not an xml serializable list");
        }
        ArrayList<String> arrayList = new ArrayList<String>(hierarchicalParameter.getNumberOfChildren());
        for (HierarchicalParameter hierarchicalParameter2 : hierarchicalParameter.getChildren()) {
            arrayList.add(StringXmlObject.valueOf(hierarchicalParameter2));
        }
        return arrayList;
    }
}

