/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs;

import com.ibm.arcs.ConfigurationManager;
import com.ibm.arcs.Engine;
import com.ibm.arcs.environment.EnvironmentManager;
import com.ibm.arcs.station.StationManager;
import com.ibm.arcs.train.TrainManager;
import com.ibm.arcs.transport.TransportServerFactoryManager;
import java.io.File;

public class ARCS {
    private static ARCS _instance = null;
    private final Engine engine;
    private final TrainManager trainManager;
    private final StationManager stationManager;
    private final ConfigurationManager configurationManager = new ConfigurationManager(new File("foo"));
    private final TransportServerFactoryManager transportServerFactoryManager;
    private final EnvironmentManager environmentManager;

    private ARCS() {
        this.trainManager = TrainManager.getInstance();
        this.stationManager = StationManager.getInstance();
        this.transportServerFactoryManager = TransportServerFactoryManager.getInstance();
        this.environmentManager = EnvironmentManager.getInstance();
        this.engine = new Engine(this.trainManager, this.stationManager);
    }

    public static ARCS getInstance() {
        if (_instance == null) {
            _instance = new ARCS();
        }
        return _instance;
    }

    public void start() {
        this.engine.run();
    }

    public void stop() {
        this.trainManager.disableTrainCreation();
        this.engine.stop();
        System.exit(0);
    }
}

