/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.basic.strings.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigurationManager {
    File configFile;
    Document doc;
    HashMap<String, HierarchicalParameter> transportServersParameters;

    public ConfigurationManager(File file) {
        this.configFile = file;
        this.transportServersParameters = new HashMap();
    }

    public HierarchicalParameter getParameters(String string) {
        return this.transportServersParameters.get(string);
    }

    public void printKeys(PrintStream printStream) {
        for (String string : this.transportServersParameters.keySet()) {
            printStream.println("key: " + string);
        }
    }

    public void addTransportServer() {
    }

    private void parseTransportServers() {
        NodeList nodeList = this.doc.getElementsByTagName("transportServer");
        int n = 0;
        while (n < nodeList.getLength()) {
            String string;
            String string2;
            Node node;
            Node node2 = nodeList.item(n);
            NodeList nodeList2 = node2.getChildNodes();
            HierarchicalParameter hierarchicalParameter = null;
            int n2 = 0;
            while (n2 < nodeList2.getLength()) {
                node = nodeList2.item(n2);
                string2 = node.getNodeName();
                if (string2.equals("name")) {
                    string = node.getTextContent();
                    hierarchicalParameter = new HierarchicalParameter("name", string, null);
                    this.transportServersParameters.put(string, hierarchicalParameter);
                    break;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < nodeList2.getLength()) {
                node = nodeList2.item(n2);
                string2 = node.getNodeName();
                if (string2.equals("id")) {
                    string = node.getTextContent();
                    new HierarchicalParameter(string2, string, hierarchicalParameter);
                } else if (string2.equals("port")) {
                    string = node.getTextContent();
                    new HierarchicalParameter(string2, string, hierarchicalParameter);
                } else if (string2.equals("backlog")) {
                    string = node.getTextContent();
                    new HierarchicalParameter(string2, string, hierarchicalParameter);
                } else if (string2.equals("minThreads")) {
                    string = node.getTextContent();
                    new HierarchicalParameter(string2, string, hierarchicalParameter);
                } else if (string2.equals("maxThreads")) {
                    string = node.getTextContent();
                    new HierarchicalParameter(string2, string, hierarchicalParameter);
                } else if (string2.equals("sessionFactory")) {
                    string = node.getTextContent();
                    new HierarchicalParameter(string2, string, hierarchicalParameter);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void parseFile() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.doc = documentBuilder.parse(this.configFile);
            this.doc.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void printRootElement() {
        System.out.println("Root element: " + this.doc.getDocumentElement().getNodeName());
        this.printChildren(this.doc.getChildNodes(), 0);
    }

    public void printChildren(NodeList nodeList, int n) {
        String string = new String();
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + " ";
            ++n2;
        }
        n2 = 0;
        while (n2 < nodeList.getLength()) {
            NodeList nodeList2;
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                System.out.println(String.valueOf(string) + node.getNodeName());
            }
            if (node.getNodeType() == 3 && node.getNodeValue().length() > 1) {
                System.out.println(String.valueOf(string) + " Value: " + StringUtils.removeNewlines((String)StringUtils.removeLeadingTrailingSpaces((String)node.getNodeValue())));
            }
            if ((nodeList2 = node.getChildNodes()).getLength() > 0) {
                this.printChildren(nodeList2, n + 1);
            }
            ++n2;
        }
    }

    public static void main(String[] stringArray) {
        File file = new File("/tmp/arcsconfig.xml");
        ConfigurationManager configurationManager = new ConfigurationManager(file);
        configurationManager.parseFile();
        configurationManager.parseTransportServers();
        HierarchicalParameter hierarchicalParameter = configurationManager.getParameters("Interactive Transport Server");
        PrintWriter printWriter = new PrintWriter(System.out);
        hierarchicalParameter.print(printWriter);
        hierarchicalParameter = configurationManager.getParameters("HTTP Transport Server");
        hierarchicalParameter.print(printWriter);
    }
}

