/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs;

import com.ibm.arcs.Route;
import com.ibm.arcs.configuration.Configuration;
import com.ibm.arcs.session.interactive.InteractiveSessionFactory;
import com.ibm.arcs.station.StationManager;
import com.ibm.arcs.train.Train;
import com.ibm.arcs.train.TrainManager;
import com.ibm.arcs.transport.TransportServerFactoryManager;
import com.ibm.arcs.transport.socket.SocketTransportServer;
import com.ibm.arcs.transport.socket.SocketTransportServerFactory;

public class Engine
implements Runnable {
    public static volatile boolean shutdown = false;
    public final TrainManager trainManager;
    public final StationManager stationManager;

    Engine(TrainManager trainManager, StationManager stationManager) {
        Configuration.getConfiguration();
        this.trainManager = trainManager;
        this.stationManager = stationManager;
    }

    public static void main(String[] stringArray) {
        SocketTransportServerFactory socketTransportServerFactory = new SocketTransportServerFactory();
        SocketTransportServer socketTransportServer = socketTransportServerFactory.createSocketTransportServer(InteractiveSessionFactory.getDefault(), 5678, 10, 1);
        new Thread(socketTransportServer).start();
        System.out.println("foo");
    }

    public void createTestServers() {
        SocketTransportServerFactory socketTransportServerFactory = new SocketTransportServerFactory();
        SocketTransportServer socketTransportServer = socketTransportServerFactory.createSocketTransportServer(InteractiveSessionFactory.getDefault(), 5678, 10, 1);
        TransportServerFactoryManager transportServerFactoryManager = TransportServerFactoryManager.getInstance();
        transportServerFactoryManager.registerTransportServerFactory(socketTransportServerFactory);
        new Thread(socketTransportServer).start();
    }

    @Override
    public void run() {
        this.createTestServers();
        while (!shutdown) {
            this.processTrains();
        }
    }

    public void stop() {
        shutdown = true;
    }

    private void processTrains() {
        Train[] trainArray;
        System.out.print("Processing...");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        Train[] trainArray2 = trainArray = this.trainManager.getReadyTrains();
        int n = trainArray.length;
        int n2 = 0;
        while (n2 < n) {
            Train train = trainArray2[n2];
            this.processTrain(train);
            ++n2;
        }
        System.out.println("Done!");
    }

    private void processTrain(Train train) {
        train.printTrainDescription(System.out);
        Route route = train.getRoute();
        while (route.hasNextStop()) {
            route.nextStop();
        }
    }

    public void loadAdapter() {
    }

    public void loadService() {
    }
}

