/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs;

import com.ibm.arcs.Waypoint;
import com.ibm.arcs.train.Train;
import java.util.ArrayList;

public class Route {
    private ArrayList<Waypoint> stops = new ArrayList();
    private int currentStopIndex = -1;
    private Train train;

    private Route() {
    }

    public Route(Train train) {
        this();
        this.train = train;
    }

    public int getCurrentStopIndex() {
        return this.currentStopIndex;
    }

    public Waypoint getStop(int n) {
        return this.stops.get(n);
    }

    public Waypoint getCurentStop() {
        return this.stops.get(this.currentStopIndex);
    }

    public boolean hasNextStop() {
        return this.currentStopIndex < this.stops.size() - 1;
    }

    public Waypoint nextStop() {
        if (this.hasNextStop()) {
            return this.stops.get(++this.currentStopIndex);
        }
        return null;
    }

    public ArrayList<Waypoint> getStops() {
        return this.stops;
    }

    public void add(Waypoint waypoint) {
        waypoint.setRoute(this);
        this.stops.add(waypoint);
    }

    public void add(int n, Waypoint waypoint) {
        if (n <= this.currentStopIndex) {
            throw new IndexOutOfBoundsException("Cannot add a stop at or below current stop index");
        }
        this.stops.add(n, waypoint);
    }

    public Train getTrain() {
        return this.train;
    }
}

