/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.event;

import com.ibm.arcs.event.EventType;
import com.ibm.arcs.event.IEvent;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class EventHistory<T extends IEvent<? extends EventType, ?>> {
    private TreeMap<Integer, T> history = new TreeMap();
    private Integer lastSequenceNumber = 0;

    public EventHistory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventHistory(EventHistory<T> eventHistory, Integer n, Integer n2) {
        this();
        EventHistory<T> eventHistory2 = this;
        synchronized (eventHistory2) {
            if (!eventHistory.history.isEmpty()) {
                if (eventHistory.history.size() == 0) {
                    return;
                }
                if (n == null) {
                    n = eventHistory.history.firstKey();
                } else if (n > eventHistory.history.lastKey()) {
                    return;
                }
                if (n2 == null) {
                    n2 = eventHistory.history.lastKey();
                }
                SortedMap<Integer, T> sortedMap = eventHistory.history.subMap(n, n2 + 1);
                for (Integer n3 : sortedMap.keySet()) {
                    super.add(n3, (IEvent)sortedMap.get(n3));
                }
            }
        }
    }

    public void add(T t) {
        this.lastSequenceNumber = this.lastSequenceNumber + 1;
        this.add(this.lastSequenceNumber, t);
    }

    private void add(Integer n, T t) {
        this.history.put(n, t);
    }

    public void add(EventHistory<T> eventHistory) {
        for (Map.Entry<Integer, T> entry : eventHistory.history.entrySet()) {
            this.add(entry.getKey(), (IEvent)entry.getValue());
        }
    }

    public T getEvent(Integer n) {
        return (T)((IEvent)this.history.get(n));
    }

    public EventHistory<T> getEventsFrom(Integer n) {
        return new EventHistory<T>(this, n, null);
    }

    public EventHistory<T> getAll() {
        return new EventHistory<T>(this, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getLastSeqNum() {
        Integer n;
        TreeMap<Integer, T> treeMap = this.history;
        synchronized (treeMap) {
            n = !this.history.isEmpty() ? this.history.lastKey() : null;
        }
        return n;
    }

    public int length() {
        return this.history.size();
    }

    public T[] toArray() {
        IEvent[] iEventArray = (IEvent[])this.history.values().toArray();
        return iEventArray;
    }
}

