/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.service;

import com.ibm.arcs.IService;
import com.ibm.arcs.service.ArcsServiceFactory;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class ArcsService {
    private static final String TAG_ARCSSERVICE = "arcsService";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_CLASS = "class";
    private static final String ATT_TARGETCLASS = "targetClass";
    private static ArcsService[] cachedArcsServices;
    private final IConfigurationElement configElement;
    private final String id;
    private final String name;
    private final IService service;
    private ArcsServiceFactory factory;

    public ArcsService(IConfigurationElement iConfigurationElement) {
        this.configElement = iConfigurationElement;
        this.id = ArcsService.getAttribute(iConfigurationElement, ATT_ID, null);
        this.name = ArcsService.getAttribute(iConfigurationElement, ATT_NAME, this.id);
        ArcsService.getAttribute(iConfigurationElement, ATT_CLASS, null);
        try {
            this.service = (IService)iConfigurationElement.createExecutableExtension(ATT_CLASS);
        }
        catch (CoreException coreException) {
            throw new IllegalArgumentException("Error creating ARCS Service");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("ARCS Service must implement IArcsService");
        }
    }

    public static ArcsService[] getArcsServices() {
        if (cachedArcsServices != null) {
            return cachedArcsServices;
        }
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.arcs", TAG_ARCSSERVICE).getExtensions();
        ArrayList<ArcsService> arrayList = new ArrayList<ArcsService>(20);
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                ArcsService arcsService = ArcsService.parseType(iConfigurationElementArray[n2], arrayList.size());
                if (arcsService != null) {
                    arrayList.add(arcsService);
                }
                ++n2;
            }
            ++n;
        }
        cachedArcsServices = arrayList.toArray(new ArcsService[arrayList.size()]);
        return cachedArcsServices;
    }

    private static ArcsService parseType(IConfigurationElement iConfigurationElement, int n) {
        if (!iConfigurationElement.getName().equals(TAG_ARCSSERVICE)) {
            return null;
        }
        try {
            return new ArcsService(iConfigurationElement);
        }
        catch (Exception exception) {
            String string = iConfigurationElement.getAttribute(ATT_NAME);
            if (string == null) {
                string = "[missing name attribute]";
            }
            String cfr_ignored_0 = "Failed to load arcsService named " + string + " in " + iConfigurationElement.getDeclaringExtension().getNamespaceIdentifier();
            return null;
        }
    }

    public static void disposeTypes() {
        if (cachedArcsServices == null) {
            return;
        }
        int n = 0;
        while (n < cachedArcsServices.length) {
            cachedArcsServices[n].dispose();
            ++n;
        }
    }

    private static String getAttribute(IConfigurationElement iConfigurationElement, String string, String string2) {
        String string3 = iConfigurationElement.getAttribute(string);
        if (string3 != null) {
            return string3;
        }
        if (string2 != null) {
            return string2;
        }
        throw new IllegalArgumentException("Missing " + string + " attribute");
    }

    public void dispose() {
        if (this.factory == null) {
            return;
        }
        this.factory.dispose();
        this.factory = null;
    }
}

