/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.session.interactive;

import com.ibm.arcs.ARCS;
import com.ibm.arcs.environment.Env;
import com.ibm.arcs.security.user.IUser;
import com.ibm.arcs.security.user.User;
import com.ibm.arcs.session.ISession;
import com.ibm.arcs.transport.ITransport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class InteractiveSession
implements ISession {
    private User user = null;
    private ITransport transport;
    boolean disconnect = false;

    InteractiveSession(ITransport iTransport) {
        this.transport = iTransport;
    }

    @Override
    public void run() {
        this.interact();
    }

    private void interact() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.transport.getInputStream()));
            PrintStream printStream = new PrintStream(this.transport.getOutputStream());
            while (!this.disconnect) {
                this.printPrompt(printStream);
                String string = bufferedReader.readLine();
                String string2 = this.processInputLine(string);
                printStream.println(string2);
                printStream.flush();
                if (!this.disconnect) continue;
                bufferedReader.close();
                printStream.close();
                this.transport.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String processInputLine(String string) {
        if (this.user == null) {
            if (string == null || string.equalsIgnoreCase("disconnect")) {
                this.disconnect = true;
                return "disconnecting";
            }
            if (string.equalsIgnoreCase("threadCount")) {
                return "Thread count:" + Thread.activeCount();
            }
            if (string.equals("getAuthMethods")) {
                return "userPassword\nIIP\nSametime\n";
            }
            if (string.equalsIgnoreCase("shutdown")) {
                ARCS.getInstance().stop();
            } else {
                return "Input was: " + string;
            }
        }
        return "Unknown user";
    }

    private void printPrompt(PrintStream printStream) {
        String string = "prompt > ";
        printStream.print(string);
    }

    @Override
    public void close() {
    }

    @Override
    public IUser getUser() {
        return this.user;
    }

    @Override
    public void send(String string) {
    }

    @Override
    public Env getEnvironment() {
        return null;
    }
}

