/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.train;

import com.ibm.arcs.Freight;
import com.ibm.arcs.Route;
import com.ibm.arcs.Waypoint;
import com.ibm.arcs.station.StationId;
import com.ibm.arcs.train.TrainId;
import java.io.PrintStream;
import java.util.ArrayList;

public class Train {
    private TrainId id;
    private StationId home;
    private Route route = new Route(this);
    private Freight freight = new Freight(this);

    private Train() {
    }

    public Train(TrainId trainId, StationId stationId) {
        this();
        this.id = trainId;
        this.home = stationId;
    }

    public TrainId getId() {
        return this.id;
    }

    public StationId getHome() {
        return this.home;
    }

    public Route getRoute() {
        return this.route;
    }

    public Freight getFreight() {
        return this.freight;
    }

    public void printTrainDescription(PrintStream printStream) {
        printStream.println("Train:");
        printStream.println(" ID=" + this.id);
        printStream.println(" Home=" + this.home);
        printStream.println(" Route:");
        Route route = this.getRoute();
        ArrayList<Waypoint> arrayList = route.getStops();
        for (Waypoint waypoint : arrayList) {
            printStream.println("  Station:");
            printStream.println("   Name=" + waypoint.getName());
            printStream.println("   Function=" + waypoint.getFunction());
            ArrayList<Integer> arrayList2 = waypoint.getWagonIndices();
            printStream.println("   Wagon Types:");
            for (Integer n : arrayList2) {
                printStream.println("    [" + n + "] " + this.getFreight().getWagon(n).getType());
            }
        }
    }
}

