/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.train;

import com.ibm.arcs.basic.uniqueid.LinearUniqueIdGenerator;
import com.ibm.arcs.station.StationId;
import com.ibm.arcs.train.Train;
import com.ibm.arcs.train.TrainId;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;

public class TrainManager {
    private static TrainManager _instance = null;
    private static final HashMap<TrainId, Train> trains = new HashMap();
    private static LinearUniqueIdGenerator trainIdGenerator = new LinearUniqueIdGenerator();
    private static final ReentrantLock lock = new ReentrantLock();
    private static boolean enableTrainCreation = true;

    public static TrainManager getInstance() {
        lock.lock();
        try {
            if (_instance == null) {
                _instance = new TrainManager();
            }
            TrainManager trainManager = _instance;
            return trainManager;
        }
        finally {
            lock.unlock();
        }
    }

    public static TrainId getUniqueTrainId() {
        Integer n;
        Integer n2 = n = Integer.valueOf(trainIdGenerator.next());
        while (trains.containsKey(n2)) {
            n2 = trainIdGenerator.next();
            if (n2 != n) continue;
            throw new RuntimeException("Unable to find a unique station id");
        }
        return new TrainId(n2);
    }

    public Train createNewTrain(StationId stationId) throws Exception {
        lock.lock();
        try {
            if (!enableTrainCreation) {
                throw new Exception("New train creation has been disabled");
            }
            Train train = new Train(TrainManager.getUniqueTrainId(), stationId);
            return train;
        }
        finally {
            lock.unlock();
        }
    }

    public Train[] getReadyTrains() {
        return new Train[0];
    }

    public void disableTrainCreation() {
        lock.lock();
        try {
            enableTrainCreation = false;
        }
        finally {
            lock.unlock();
        }
    }

    public void enableTrainCreation() {
        lock.lock();
        try {
            enableTrainCreation = true;
        }
        finally {
            lock.unlock();
        }
    }
}

