/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.transport;

import com.ibm.arcs.transport.socket.ITransportServerFactory;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TransportServerFactoryManager {
    private static TransportServerFactoryManager _instance = null;
    private static final ArrayList<ITransportServerFactory> transportServerFactories = new ArrayList();
    private static final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
    private static final Lock rlock = rwlock.readLock();
    private static final Lock wlock = rwlock.writeLock();

    private TransportServerFactoryManager() {
    }

    public static TransportServerFactoryManager getInstance() {
        wlock.lock();
        try {
            if (_instance == null) {
                _instance = new TransportServerFactoryManager();
            }
            TransportServerFactoryManager transportServerFactoryManager = _instance;
            return transportServerFactoryManager;
        }
        finally {
            wlock.unlock();
        }
    }

    public void loadTransportServerFactories() {
    }

    public void registerTransportServerFactory(ITransportServerFactory iTransportServerFactory) {
        wlock.lock();
        try {
            transportServerFactories.add(iTransportServerFactory);
        }
        finally {
            wlock.unlock();
        }
    }
}

