/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.transport.socket;

import com.ibm.arcs.session.ISession;
import com.ibm.arcs.session.ISessionFactory;
import com.ibm.arcs.transport.ITransport;
import com.ibm.arcs.transport.ITransportServer;
import com.ibm.arcs.transport.socket.SocketTransport;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ServerSocketFactory;

public class SocketTransportServer
implements ITransportServer {
    private ISessionFactory sessionFactory;
    private int port;
    private int backlog;
    private int maxThreads;
    private ServerSocketFactory ssf;
    private ServerSocket ss;
    private ExecutorService es;
    private Thread thread;
    private boolean halt = false;
    private static final ArrayList<SocketTransport> socketTransports = new ArrayList();
    private static final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
    private static final Lock rlock = rwlock.readLock();
    private static final Lock wlock = rwlock.writeLock();

    SocketTransportServer(ISessionFactory iSessionFactory, int n, int n2, int n3) throws IOException {
        this.sessionFactory = iSessionFactory;
        this.port = n;
        this.backlog = n2;
        this.maxThreads = n3;
        this.ssf = ServerSocketFactory.getDefault();
        this.ss = this.ssf.createServerSocket(this.port, this.backlog);
        this.es = Executors.newFixedThreadPool(this.maxThreads);
    }

    private static void registerSocketTransport(SocketTransport socketTransport) {
        wlock.lock();
        try {
            socketTransports.add(socketTransport);
        }
        finally {
            wlock.unlock();
        }
    }

    private static Collection<ITransport> getSocketTransportsAsITransports() {
        rlock.lock();
        try {
            Vector<ITransport> vector = new Vector<ITransport>();
            for (SocketTransport socketTransport : socketTransports) {
                vector.add(socketTransport);
            }
            Vector<ITransport> vector2 = vector;
            return vector2;
        }
        finally {
            rlock.unlock();
        }
    }

    @Override
    public synchronized void start() {
        this.thread = new Thread(this);
        this.thread.run();
    }

    @Override
    public synchronized void stop() {
        this.halt = true;
    }

    @Override
    public synchronized void run() {
        while (!this.halt) {
            try {
                this.createSocketTransport();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void createSocketTransport() throws IOException {
        Socket socket = this.ss.accept();
        SocketTransport socketTransport = new SocketTransport(socket);
        ISession iSession = this.sessionFactory.newSession(socketTransport);
        socketTransport.setSession(iSession);
        SocketTransportServer.registerSocketTransport(socketTransport);
        this.es.execute(iSession);
    }

    @Override
    public final Collection<ITransport> getTransports() {
        return SocketTransportServer.getSocketTransportsAsITransports();
    }
}

