/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.administration;

import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.arcs.database.connection.ConnectionParametersBuilder;
import com.ibm.informix.administration.AdminCommandStatus;
import com.ibm.informix.administration.CommandHistory;
import com.ibm.informix.administration.Messages;
import com.ibm.informix.administration.SQLAdministrationCommand;
import com.ibm.informix.administration.SQLAdministrationInstruction;
import com.ibm.informix.administration.TaskCommandStatus;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class AbstractSQLAdministrationCommand
implements SQLAdministrationCommand {
    protected final SQLAdministrationInstruction sqlAdministrationInstruction;
    protected final ConnectionParameters connectionParameters;
    protected CommandHistory commandHistory;

    public AbstractSQLAdministrationCommand(ConnectionParameters connectionParameters, SQLAdministrationInstruction sQLAdministrationInstruction) {
        this.connectionParameters = connectionParameters;
        this.sqlAdministrationInstruction = sQLAdministrationInstruction;
    }

    public final void execute() throws Exception {
        this.executeAdmin();
    }

    @Override
    public final synchronized AdminCommandStatus executeAdmin() throws ClassNotFoundException, SQLException {
        Connection connection = this.establishConnection();
        AdminCommandStatus adminCommandStatus = null;
        this.preExecute(connection);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(this.getAdminSql());
        while (resultSet.next()) {
            adminCommandStatus = new AdminCommandStatus(this, resultSet.getInt(1));
        }
        connection.close();
        return adminCommandStatus;
    }

    @Override
    public final synchronized TaskCommandStatus executeTask() throws ClassNotFoundException, SQLException {
        Connection connection = this.establishConnection();
        TaskCommandStatus taskCommandStatus = null;
        this.preExecute(connection);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(this.getTaskSql());
        while (resultSet.next()) {
            taskCommandStatus = new TaskCommandStatus(this, resultSet.getString(1));
        }
        connection.close();
        return taskCommandStatus;
    }

    @Override
    public abstract AbstractSQLAdministrationCommand newConnectionParameters(ConnectionParameters var1);

    @Override
    public SQLAdministrationInstruction getSQLAdministrationInstruction() {
        return this.sqlAdministrationInstruction;
    }

    @Override
    public ConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    protected void preExecute(Connection connection) {
    }

    protected void postExecute(Connection connection) {
    }

    protected final Connection establishConnection() throws ClassNotFoundException, SQLException {
        if (this.connectionParameters == null) {
            throw new UnsatisfiedLinkError(Messages.Error_ConnectionParametersAreUndefined);
        }
        ConnectionParametersBuilder connectionParametersBuilder = this.connectionParameters.getConnectionParametersBuilder();
        connectionParametersBuilder.setDatabaseName("sysadmin");
        Connection connection = connectionParametersBuilder.getConnectionParameters().getConnection();
        return connection;
    }

    private String getAdminSql() {
        return this.getSQLAdministrationInstruction().getSQLAdministrationParameters().toAdminString();
    }

    private String getTaskSql() {
        return this.getSQLAdministrationInstruction().getSQLAdministrationParameters().toTaskString();
    }
}

