/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.administration;

import com.ibm.informix.administration.CommandHistory;
import com.ibm.informix.administration.SQLAdministrationCommand;
import java.sql.SQLException;

public class AdminCommandStatus {
    private final SQLAdministrationCommand sqlAdminCommand;
    private final int returnValue;

    public AdminCommandStatus(SQLAdministrationCommand sQLAdministrationCommand, int n) {
        this.sqlAdminCommand = sQLAdministrationCommand;
        this.returnValue = n;
    }

    public SQLAdministrationCommand getSQLAdministrationCommand() {
        return this.sqlAdminCommand;
    }

    public int getCommandHistoryNumber() {
        return AdminCommandStatus.convertReturnValueToCommandHistoryNumber(this.returnValue);
    }

    public String getStatusMessage() throws SQLException, ClassNotFoundException {
        CommandHistory commandHistory = CommandHistory.readCommandHistory(this.sqlAdminCommand.getConnectionParameters(), this.returnValue);
        return commandHistory.returnMessage;
    }

    public boolean completedSuccessfully() {
        return this.returnValue >= 0;
    }

    public boolean hasCommandHistory() {
        return this.returnValue != 0;
    }

    private static int convertReturnValueToCommandHistoryNumber(int n) {
        return Math.abs(n);
    }
}

