/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.administration;

import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.arcs.database.connection.ConnectionParametersBuilder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CommandHistory {
    public final int number;
    public final String time;
    public final String user;
    public final String hostname;
    public final String executed;
    public final String returnStatus;
    public final String returnMessage;

    CommandHistory(int n, String string, String string2, String string3, String string4, String string5, String string6) {
        this.number = n;
        this.time = string;
        this.user = string2;
        this.hostname = string3;
        this.executed = string4;
        this.returnStatus = string5;
        this.returnMessage = string6;
    }

    public static CommandHistory readCommandHistory(ConnectionParameters connectionParameters, int n) throws SQLException, ClassNotFoundException {
        ConnectionParametersBuilder connectionParametersBuilder = connectionParameters.getConnectionParametersBuilder();
        connectionParametersBuilder.setDatabaseName("sysadmin");
        Connection connection = connectionParametersBuilder.getConnectionParameters().getConnection();
        CommandHistory commandHistory = CommandHistory.readCommandHistory(connection, n);
        connection.close();
        return commandHistory;
    }

    public static CommandHistory readCommandHistory(Connection connection, int n) throws SQLException {
        CommandHistory commandHistory = null;
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(CommandHistory.buildSqlSelect(n));
        if (resultSet.next()) {
            int n2 = resultSet.getInt("cmd_number");
            String string = resultSet.getString("cmd_exec_time");
            String string2 = resultSet.getString("cmd_user");
            String string3 = resultSet.getString("cmd_hostname");
            String string4 = resultSet.getString("cmd_executed");
            String string5 = resultSet.getString("cmd_ret_status");
            String string6 = resultSet.getString("cmd_ret_msg");
            commandHistory = new CommandHistory(n2, string, string2, string3, string4, string5, string6);
        }
        return commandHistory;
    }

    private static String buildSqlSelect(int n) {
        return "SELECT * FROM command_history WHERE cmd_number=" + Integer.toString(Math.abs(n));
    }
}

