/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.administration;

import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.informix.administration.AdminCommandStatus;
import com.ibm.informix.administration.AdminInstructionStatus;
import com.ibm.informix.administration.CommandHistory;
import com.ibm.informix.administration.SQLAdministrationCommand;
import com.ibm.informix.administration.SQLAdministrationInstruction;
import com.ibm.informix.administration.TaskCommandStatus;
import com.ibm.informix.connection.InformixJdbcConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;

public class SQLAdministration {
    private final ConnectionParameters connectionParameters;
    private final Connection connection;

    public SQLAdministration(ConnectionParameters connectionParameters) throws SQLException, ClassNotFoundException {
        this.connectionParameters = connectionParameters;
        InformixJdbcConnection informixJdbcConnection = new InformixJdbcConnection(connectionParameters);
        informixJdbcConnection.connect();
        this.connection = informixJdbcConnection.getDBConnection();
    }

    public ConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    protected void finalize() throws Throwable {
        this.connection.close();
    }

    public synchronized CommandHistory getCommandHistory(int n) throws SQLException {
        return CommandHistory.readCommandHistory(this.connection, n);
    }

    public synchronized AdminCommandStatus executeAdmin(SQLAdministrationCommand sQLAdministrationCommand) throws SQLException, ClassNotFoundException {
        return sQLAdministrationCommand.newConnectionParameters(this.connectionParameters).executeAdmin();
    }

    public synchronized TaskCommandStatus executeTask(SQLAdministrationCommand sQLAdministrationCommand) throws SQLException, ClassNotFoundException {
        return sQLAdministrationCommand.newConnectionParameters(this.connectionParameters).executeTask();
    }

    public static List<AdminInstructionStatus> executeAdmin(Connection connection, SQLAdministrationInstruction ... sQLAdministrationInstructionArray) throws SQLException {
        Vector<AdminInstructionStatus> vector = new Vector<AdminInstructionStatus>(sQLAdministrationInstructionArray.length);
        SQLAdministrationInstruction[] sQLAdministrationInstructionArray2 = sQLAdministrationInstructionArray;
        int n = sQLAdministrationInstructionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SQLAdministrationInstruction sQLAdministrationInstruction = sQLAdministrationInstructionArray2[n2];
            vector.add(sQLAdministrationInstruction.execute(connection));
            ++n2;
        }
        return vector;
    }

    public static AdminInstructionStatus executeAdmin(SQLAdministrationCommand sQLAdministrationCommand, Connection connection) throws SQLException {
        return sQLAdministrationCommand.getSQLAdministrationInstruction().execute(connection);
    }
}

