/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.administration;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public final class SQLAdministrationParameters {
    private final Vector<String> parameters = new Vector();
    private static final int maxParameters = 28;

    public static int getMaximumParameters() {
        return 28;
    }

    public void addParameter(String string) {
        if (this.parameters.size() >= 28) {
            throw new ArrayIndexOutOfBoundsException("Maximum parameters has been reached");
        }
        this.parameters.add(string);
    }

    public void addAllParameters(List<String> list) {
        if (this.parameters.size() + list.size() >= 28) {
            throw new ArrayIndexOutOfBoundsException("Attempt to exceed maximum parameters");
        }
        this.parameters.addAll(list);
    }

    public void addParameters(String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.addParameter(string);
            ++n2;
        }
    }

    public void insertParameter(String string, int n) {
        if (this.parameters.size() >= 28) {
            throw new ArrayIndexOutOfBoundsException("Maximum parameters has been reached");
        }
        this.parameters.insertElementAt(string, n);
    }

    public int size() {
        return this.parameters.size();
    }

    public String getParameter(int n) {
        return this.parameters.get(n);
    }

    public String toTaskString() {
        String string = "EXECUTE FUNCTION SYSADMIN:TASK " + this.parametersToString();
        return string;
    }

    public String toAdminString() {
        String string = "EXECUTE FUNCTION SYSADMIN:ADMIN " + this.parametersToString();
        return string;
    }

    private String parametersToString() {
        String string = "(";
        Iterator<String> iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            string = String.valueOf(string) + "'";
            string = String.valueOf(string) + iterator.next();
            string = String.valueOf(string) + "'";
            if (!iterator.hasNext()) continue;
            string = String.valueOf(string) + ",";
        }
        string = String.valueOf(string) + ")";
        return string;
    }
}

