/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.administration.instructions;

import com.ibm.arcs.basic.unit.ByteUnit;
import com.ibm.arcs.basic.unit.ByteValue;
import com.ibm.informix.administration.AbstractUndoableSQLAdministrationInstruction;
import com.ibm.informix.administration.SQLAdministrationInstruction;
import com.ibm.informix.administration.SQLAdministrationParameters;
import com.ibm.informix.administration.instructions.BlobSpaceDeleteInstruction;

public final class BlobSpaceCreateInstruction
extends AbstractUndoableSQLAdministrationInstruction {
    private final String name;
    private final String path;
    private final ByteValue size;
    private final ByteValue offset;
    private final ByteValue pageSize;

    public BlobSpaceCreateInstruction(String string, String string2, ByteValue byteValue, ByteValue byteValue2, ByteValue byteValue3) {
        super(BlobSpaceCreateInstruction.buildSqlAdministrationParameters(string, string2, byteValue, byteValue2, byteValue3));
        this.name = string;
        this.path = string2;
        this.size = byteValue;
        this.offset = byteValue2;
        this.pageSize = byteValue3;
    }

    @Override
    public SQLAdministrationInstruction getUndoInstruction() {
        return new BlobSpaceDeleteInstruction(this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public ByteValue getSize() {
        return this.size;
    }

    public ByteValue getOffset() {
        return this.offset;
    }

    public ByteValue getPageSize() {
        return this.pageSize;
    }

    private static SQLAdministrationParameters buildSqlAdministrationParameters(String string, String string2, ByteValue byteValue, ByteValue byteValue2, ByteValue byteValue3) {
        SQLAdministrationParameters sQLAdministrationParameters = new SQLAdministrationParameters();
        sQLAdministrationParameters.addParameters("CREATE BLOBSPACE", string, string2);
        sQLAdministrationParameters.addParameter(byteValue.getValueAs(ByteUnit.KIBIBYTE).toString());
        sQLAdministrationParameters.addParameter(byteValue2.getValueAs(ByteUnit.KIBIBYTE).toString());
        sQLAdministrationParameters.addParameter(byteValue3.getValueAs(ByteUnit.KIBIBYTE).toString());
        return sQLAdministrationParameters;
    }
}

