/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.administration.instructions;

import com.ibm.arcs.basic.number.NaturalNumber;
import com.ibm.arcs.basic.number.Percentage;
import com.ibm.arcs.basic.unit.ByteUnit;
import com.ibm.arcs.basic.unit.ByteValue;
import com.ibm.informix.administration.AbstractSQLAdministrationInstruction;
import com.ibm.informix.administration.SQLAdministrationParameters;
import com.ibm.informix.configuration.Messages;
import java.math.BigInteger;

public final class BufferPoolAddInstruction
extends AbstractSQLAdministrationInstruction {
    private final ByteValue pageSize;
    private final NaturalNumber buffers;
    private final NaturalNumber numberOfLRUQueues;
    private final Percentage maxDirty;
    private final Percentage minDirty;

    public BufferPoolAddInstruction(ByteValue byteValue) {
        this(byteValue, new NaturalNumber(Integer.valueOf(1000)), null, null, null);
    }

    public BufferPoolAddInstruction(ByteValue byteValue, NaturalNumber naturalNumber) {
        this(byteValue, naturalNumber, null, null, null);
    }

    public BufferPoolAddInstruction(ByteValue byteValue, NaturalNumber naturalNumber, NaturalNumber naturalNumber2, Percentage percentage, Percentage percentage2) {
        super(BufferPoolAddInstruction.buildSQLAdministrationParameters(byteValue, naturalNumber, naturalNumber2, percentage, percentage2));
        this.pageSize = byteValue;
        this.buffers = naturalNumber;
        this.numberOfLRUQueues = naturalNumber2;
        this.maxDirty = percentage;
        this.minDirty = percentage2;
    }

    public ByteValue getPageSize() {
        return this.pageSize;
    }

    public NaturalNumber getBuffers() {
        return this.buffers;
    }

    public NaturalNumber getNumberOfLRUQueues() {
        return this.numberOfLRUQueues;
    }

    public Percentage getMaxDirty() {
        return this.maxDirty;
    }

    public Percentage getMinDirty() {
        return this.minDirty;
    }

    private static SQLAdministrationParameters buildSQLAdministrationParameters(ByteValue byteValue, NaturalNumber naturalNumber, NaturalNumber naturalNumber2, Percentage percentage, Percentage percentage2) {
        BigInteger bigInteger = byteValue.getValueAs(ByteUnit.KIBIBYTE).toBigInteger();
        if (bigInteger.compareTo(BigInteger.ONE) < 0) {
            throw new IllegalArgumentException(Messages.Error_PageSizeMustBeGreaterThanOrEqualToOne);
        }
        SQLAdministrationParameters sQLAdministrationParameters = new SQLAdministrationParameters();
        sQLAdministrationParameters.addParameter("ADD BUFFERPOOL");
        sQLAdministrationParameters.addParameter(bigInteger.toString());
        sQLAdministrationParameters.addParameter(naturalNumber.toString());
        if (naturalNumber2 != null) {
            sQLAdministrationParameters.addParameter(naturalNumber2.toString());
            if (percentage != null) {
                sQLAdministrationParameters.addParameter(percentage.toString());
                if (percentage2 != null) {
                    sQLAdministrationParameters.addParameter(percentage2.toString());
                }
            }
        }
        return sQLAdministrationParameters;
    }
}

