/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.administration.instructions;

import com.ibm.arcs.basic.unit.ByteUnit;
import com.ibm.arcs.basic.unit.ByteValue;
import com.ibm.informix.administration.AbstractSQLAdministrationInstruction;
import com.ibm.informix.administration.SQLAdministrationParameters;

public final class ChunkAddMirrorInstruction
extends AbstractSQLAdministrationInstruction {
    private final String space;
    private final String path;
    private final ByteValue size;
    private final ByteValue offset;
    private final String mirrorPath;
    private final ByteValue mirrorOffset;
    private static final ByteValue minimumSize = new ByteValue(1000L, ByteUnit.KIBIBYTE);
    private static final ByteValue maximumOffset = new ByteValue(4L, ByteUnit.TEBIBYTE);

    public ChunkAddMirrorInstruction(String string, String string2, ByteValue byteValue, ByteValue byteValue2, String string3, ByteValue byteValue3) {
        super(ChunkAddMirrorInstruction.buildSQLAdministrationParameters(string, string2, byteValue, byteValue2, string3, byteValue3));
        this.space = string;
        this.path = string2;
        this.size = byteValue;
        this.offset = byteValue2;
        this.mirrorPath = string3;
        this.mirrorOffset = byteValue3;
    }

    public String getSpace() {
        return this.space;
    }

    public String getPath() {
        return this.path;
    }

    public ByteValue getSize() {
        return this.size;
    }

    public ByteValue getOffset() {
        return this.offset;
    }

    public String getMirrorPath() {
        return this.mirrorPath;
    }

    public ByteValue getMirrorOffset() {
        return this.mirrorOffset;
    }

    private static SQLAdministrationParameters buildSQLAdministrationParameters(String string, String string2, ByteValue byteValue, ByteValue byteValue2, String string3, ByteValue byteValue3) {
        SQLAdministrationParameters sQLAdministrationParameters = new SQLAdministrationParameters();
        sQLAdministrationParameters.addParameters("ADD MIRROR", string, string2);
        if (!(ChunkAddMirrorInstruction.validateAndAppendSize(sQLAdministrationParameters, byteValue) && ChunkAddMirrorInstruction.validateAndAppendOffset(sQLAdministrationParameters, byteValue2) && ChunkAddMirrorInstruction.validateAndAppendMirrorPath(sQLAdministrationParameters, string3) && ChunkAddMirrorInstruction.validateAndAppendMirrorOffset(sQLAdministrationParameters, byteValue3))) {
            throw new RuntimeException("An argument was not validated and failed to throw is own exception. Please debug and report.");
        }
        return sQLAdministrationParameters;
    }

    private static boolean validateAndAppendSize(SQLAdministrationParameters sQLAdministrationParameters, ByteValue byteValue) {
        if (byteValue.compareTo(minimumSize) < 0) {
            throw new IllegalArgumentException("size < " + minimumSize);
        }
        sQLAdministrationParameters.addParameter(byteValue.getValueAs(ByteUnit.KILOBYTE).toString());
        return true;
    }

    private static boolean validateAndAppendOffset(SQLAdministrationParameters sQLAdministrationParameters, ByteValue byteValue) {
        if (byteValue != null) {
            if (byteValue.compareTo(maximumOffset) > 0) {
                throw new IllegalArgumentException("offset > " + maximumOffset);
            }
            sQLAdministrationParameters.addParameter(byteValue.getValueAs(ByteUnit.KIBIBYTE).toString());
        }
        return true;
    }

    private static boolean validateAndAppendMirrorPath(SQLAdministrationParameters sQLAdministrationParameters, String string) {
        if (string != null) {
            sQLAdministrationParameters.addParameter(string);
        }
        return true;
    }

    private static boolean validateAndAppendMirrorOffset(SQLAdministrationParameters sQLAdministrationParameters, ByteValue byteValue) {
        if (byteValue != null) {
            if (byteValue.compareTo(maximumOffset) > 0) {
                throw new IllegalArgumentException("mirrorOffset > " + maximumOffset);
            }
            sQLAdministrationParameters.addParameter(byteValue.getValueAs(ByteUnit.KIBIBYTE).toString());
        }
        return true;
    }
}

