/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.administration.instructions;

import com.ibm.arcs.basic.unit.ByteUnit;
import com.ibm.arcs.basic.unit.ByteValue;
import com.ibm.informix.administration.AbstractUndoableSQLAdministrationInstruction;
import com.ibm.informix.administration.SQLAdministrationInstruction;
import com.ibm.informix.administration.SQLAdministrationParameters;
import com.ibm.informix.administration.instructions.ChunkOfflineInstruction;

public final class ChunkOnlineInstruction
extends AbstractUndoableSQLAdministrationInstruction {
    private final String path;
    private final ByteValue offset;

    public ChunkOnlineInstruction(String string, ByteValue byteValue) {
        super(ChunkOnlineInstruction.buildSQLAdministrationParameters(string, byteValue));
        this.path = string;
        this.offset = byteValue;
    }

    public String getPath() {
        return this.path;
    }

    public ByteValue getOffset() {
        return this.offset;
    }

    @Override
    public SQLAdministrationInstruction getUndoInstruction() {
        return new ChunkOfflineInstruction(this.path, this.offset);
    }

    private static SQLAdministrationParameters buildSQLAdministrationParameters(String string, ByteValue byteValue) {
        SQLAdministrationParameters sQLAdministrationParameters = new SQLAdministrationParameters();
        sQLAdministrationParameters.addParameters("ALTER CHUNK ONLINE", string, byteValue.getValueAs(ByteUnit.KIBIBYTE).toString());
        return sQLAdministrationParameters;
    }
}

