/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.administration.instructions;

import com.ibm.arcs.basic.unit.ByteUnit;
import com.ibm.arcs.basic.unit.ByteValue;
import com.ibm.informix.administration.AbstractUndoableSQLAdministrationInstruction;
import com.ibm.informix.administration.SQLAdministrationInstruction;
import com.ibm.informix.administration.SQLAdministrationParameters;
import com.ibm.informix.administration.instructions.DataSpaceDeleteInstruction;
import java.math.BigInteger;

public final class DataSpaceCreateInstruction
extends AbstractUndoableSQLAdministrationInstruction {
    private final String name;
    private final String pathname;
    private final ByteValue size;
    private final ByteValue offset;
    private final ByteValue pageSize;
    private final ByteValue firstExtSize;
    private final ByteValue nextExtSize;

    public DataSpaceCreateInstruction(String string, String string2, ByteValue byteValue, ByteValue byteValue2, ByteValue byteValue3, ByteValue byteValue4, ByteValue byteValue5) {
        super(DataSpaceCreateInstruction.buildSQLAdministrationParameters(string, string2, byteValue, byteValue2, byteValue3, byteValue4, byteValue5));
        this.name = string;
        this.pathname = string2;
        this.size = byteValue;
        this.offset = byteValue2;
        this.pageSize = byteValue3;
        this.firstExtSize = byteValue4;
        this.nextExtSize = byteValue5;
    }

    @Override
    public SQLAdministrationInstruction getUndoInstruction() {
        return new DataSpaceDeleteInstruction(this.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getPathname() {
        return this.pathname;
    }

    public ByteValue getSize() {
        return this.size;
    }

    public ByteValue getOffset() {
        return this.offset;
    }

    public ByteValue getPageSize() {
        return this.pageSize;
    }

    public ByteValue getFirstExtSize() {
        return this.firstExtSize;
    }

    public ByteValue getNextExtSize() {
        return this.nextExtSize;
    }

    private static SQLAdministrationParameters buildSQLAdministrationParameters(String string, String string2, ByteValue byteValue, ByteValue byteValue2, ByteValue byteValue3, ByteValue byteValue4, ByteValue byteValue5) {
        String string3 = string.trim();
        if (string3.length() == 0) {
            throw new IllegalArgumentException("name must have non-zero length");
        }
        BigInteger bigInteger = byteValue.getValueAs(ByteUnit.KIBIBYTE).toBigInteger();
        if (bigInteger.compareTo(BigInteger.ONE) < 0) {
            throw new IllegalArgumentException("size must be greater than or equal to one");
        }
        BigInteger bigInteger2 = byteValue2.getValueAs(ByteUnit.KIBIBYTE).toBigInteger();
        if (bigInteger2.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("offset must be greater than or equal to zero");
        }
        BigInteger bigInteger3 = byteValue3.getValueAs(ByteUnit.KIBIBYTE).toBigInteger();
        if (bigInteger3.compareTo(BigInteger.ONE) < 0) {
            throw new IllegalArgumentException("pageSize must be greater than or equal to one");
        }
        SQLAdministrationParameters sQLAdministrationParameters = new SQLAdministrationParameters();
        sQLAdministrationParameters.addParameter("CREATE DBSPACE");
        sQLAdministrationParameters.addParameter(string3);
        sQLAdministrationParameters.addParameter(string2);
        sQLAdministrationParameters.addParameter(bigInteger.toString());
        sQLAdministrationParameters.addParameter(bigInteger2.toString());
        sQLAdministrationParameters.addParameter(bigInteger3.toString());
        sQLAdministrationParameters.addParameter(byteValue4.toString(ByteUnit.KIBIBYTE));
        sQLAdministrationParameters.addParameter(byteValue5.toString(ByteUnit.KIBIBYTE));
        return sQLAdministrationParameters;
    }
}

