/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.administration.instructions;

import com.ibm.arcs.basic.unit.ByteUnit;
import com.ibm.arcs.basic.unit.ByteValue;
import com.ibm.informix.administration.AbstractSQLAdministrationInstruction;
import com.ibm.informix.administration.SQLAdministrationParameters;

public final class LogAddInstruction
extends AbstractSQLAdministrationInstruction {
    private final String spaceName;
    private final ByteValue logFileSize;
    private final Integer numberOfLogFiles;
    private final Boolean afterCurrentLog;
    private static final ByteValue minimumSize = new ByteValue(200L, ByteUnit.KIBIBYTE);

    public LogAddInstruction(String string, ByteValue byteValue, Integer n, Boolean bl) {
        super(LogAddInstruction.buildSQLAdministrationParameters(string, byteValue, n, bl));
        this.spaceName = string;
        this.logFileSize = byteValue;
        this.numberOfLogFiles = n;
        this.afterCurrentLog = bl;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public ByteValue getLogFileSize() {
        return this.logFileSize;
    }

    public Integer getNumberOfLogFiles() {
        return this.numberOfLogFiles;
    }

    public Boolean getAfterCurrentLog() {
        return this.afterCurrentLog;
    }

    private static SQLAdministrationParameters buildSQLAdministrationParameters(String string, ByteValue byteValue, Integer n, Boolean bl) {
        SQLAdministrationParameters sQLAdministrationParameters = new SQLAdministrationParameters();
        sQLAdministrationParameters.addParameters("ADD LOG", string);
        if (byteValue != null) {
            if (byteValue.compareTo(minimumSize) < 0) {
                throw new IllegalArgumentException("size < 200KB");
            }
            sQLAdministrationParameters.addParameter(byteValue.toString(ByteUnit.KIBIBYTE));
            if (n != null) {
                sQLAdministrationParameters.addParameter(n.toString());
                if (bl != null) {
                    sQLAdministrationParameters.addParameter(bl.toString());
                }
            }
        }
        return sQLAdministrationParameters;
    }
}

