/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.administration.instructions;

import com.ibm.informix.administration.AbstractSQLAdministrationInstruction;
import com.ibm.informix.administration.SQLAdministrationParameters;
import com.ibm.informix.configuration.logging.InformixSpaceLogMode;

public final class LogModeAlterInstruction
extends AbstractSQLAdministrationInstruction {
    private final String database;
    private final InformixSpaceLogMode logMode;

    public LogModeAlterInstruction(String string, InformixSpaceLogMode informixSpaceLogMode) {
        super(LogModeAlterInstruction.buildSQLAdministrationParameters(string, informixSpaceLogMode));
        this.database = string;
        this.logMode = informixSpaceLogMode;
    }

    public String getDatabase() {
        return this.database;
    }

    public InformixSpaceLogMode getLogMode() {
        return this.logMode;
    }

    private static SQLAdministrationParameters buildSQLAdministrationParameters(String string, InformixSpaceLogMode informixSpaceLogMode) {
        SQLAdministrationParameters sQLAdministrationParameters = new SQLAdministrationParameters();
        sQLAdministrationParameters.addParameters("ALTER LOGMODE", string);
        switch (informixSpaceLogMode) {
            case ANSI: {
                sQLAdministrationParameters.addParameter("a");
            }
            case LOGGED_UNBUFFERED: {
                sQLAdministrationParameters.addParameter("u");
            }
            case LOGGED_BUFFERED: {
                sQLAdministrationParameters.addParameter("b");
            }
            case UNLOGGED: {
                sQLAdministrationParameters.addParameter("n");
            }
        }
        throw new IllegalArgumentException("Unknown logMode " + informixSpaceLogMode + " specified");
    }
}

